/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.acl;

import it.grid.storm.acl.AclManagementInterface;
import it.grid.storm.acl.AclManager;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.https.HTTPPluginManager;
import it.grid.storm.https.HTTPSPluginInterface;

public class AclManagerFSAndHTTPS
implements AclManager {
    private static AclManagerFSAndHTTPS instance = new AclManagerFSAndHTTPS();
    private boolean isHttpsEnabled = Configuration.getInstance().getGridhttpsEnabled();
    private final AclManagementInterface aclManagement = this.isHttpsEnabled ? HTTPPluginManager.getHTTPSPluginInstance() : null;

    private AclManagerFSAndHTTPS() {
    }

    public static AclManager getInstance() {
        return instance;
    }

    @Override
    public FilesystemPermission grantGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.grantGroupPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.grantGroupPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission grantUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.grantUserPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.grantUserPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission removeGroupPermission(LocalFile localFile, LocalUser localUser) throws IllegalArgumentException {
        if (localFile == null || localUser == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.removeGroupPermission(localUser);
        if (this.isHttpsEnabled) {
            this.aclManagement.removeGroupPermission(localFile, localUser);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission removeUserPermission(LocalFile localFile, LocalUser localUser) throws IllegalArgumentException {
        if (localFile == null || localUser == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.removeUserPermission(localUser);
        if (this.isHttpsEnabled) {
            this.aclManagement.removeUserPermission(localFile, localUser);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission revokeGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.revokeGroupPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.revokeGroupPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission revokeUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.revokeUserPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.revokeUserPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission setGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.setGroupPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.setGroupPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public FilesystemPermission setUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (!localFile.exists()) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
        }
        FilesystemPermission newPermission = localFile.setUserPermission(localUser, permission);
        if (this.isHttpsEnabled) {
            this.aclManagement.setUserPermission(localFile, localUser, permission);
        }
        return newPermission;
    }

    @Override
    public void removeHttpsPermissions(LocalFile localFile) throws IllegalArgumentException {
        if (localFile == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received file parameter is null");
        }
        if (this.isHttpsEnabled) {
            if (!localFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
            }
            this.aclManagement.removeAllPermissions(localFile);
        }
    }

    @Override
    public void grantHttpsUserPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (this.isHttpsEnabled) {
            if (!localFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
            }
            this.aclManagement.grantUserPermission(localFile, localUser, permission);
        }
    }

    @Override
    public void grantHttpsServiceUserPermission(LocalFile localFile, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " permission=" + permission);
        }
        if (this.isHttpsEnabled && this.aclManagement instanceof HTTPSPluginInterface) {
            if (!localFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
            }
            ((HTTPSPluginInterface)this.aclManagement).grantServiceUserPermission(localFile, permission);
        }
    }

    @Override
    public void grantHttpsGroupPermission(LocalFile localFile, LocalUser localUser, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || localUser == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " localUser=" + localUser + " permission=" + permission);
        }
        if (this.isHttpsEnabled) {
            if (!localFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
            }
            this.aclManagement.grantGroupPermission(localFile, localUser, permission);
        }
    }

    @Override
    public void grantHttpsServiceGroupPermission(LocalFile localFile, FilesystemPermission permission) throws IllegalArgumentException {
        if (localFile == null || permission == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: localFile=" + localFile + " permission=" + permission);
        }
        if (this.isHttpsEnabled && this.aclManagement instanceof HTTPSPluginInterface) {
            if (!localFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received file parameter points to a non existent file");
            }
            ((HTTPSPluginInterface)this.aclManagement).grantServiceGroupPermission(localFile, permission);
        }
    }

    @Override
    public void moveHttpsPermissions(LocalFile fromLocalFile, LocalFile toLocalFile) throws IllegalArgumentException {
        if (fromLocalFile == null || toLocalFile == null) {
            throw new IllegalArgumentException("Unable to perform the operation. The received null parameters: fromLocalFile=" + fromLocalFile + " toLocalFile=" + toLocalFile);
        }
        if (this.isHttpsEnabled) {
            if (!toLocalFile.exists()) {
                throw new IllegalArgumentException("Unable to perform the operation. The received destination file parameter points to a non existent file");
            }
            this.aclManagement.moveAllPermissions(fromLocalFile, toLocalFile);
        }
    }
}

