/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm;

import it.grid.storm.StoRM;
import it.grid.storm.config.Configuration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoRMCommandServer {
    private StoRM storm;
    private int listeningPort;
    private ServerSocket server = null;
    private static Logger log;
    private boolean shutdownInProgress = false;

    public StoRMCommandServer(StoRM storm) {
        this.storm = storm;
        log = LoggerFactory.getLogger(StoRMCommandServer.class);
        this.listeningPort = Configuration.getInstance().getCommandServerBindingPort();
        this.startCommandServer();
    }

    private void startCommandServer() {
        try {
            this.server = new ServerSocket(this.listeningPort);
        }
        catch (IOException e) {
            log.error("UNEXPECTED ERROR! Could not bind to listeningPort! " + e);
            System.exit(1);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        new CommandExecuterThread(StoRMCommandServer.this.server.accept(), StoRMCommandServer.this.storm).start();
                    }
                }
                catch (IOException e) {
                    log.error("UNEXPECTED ERROR! Something went wrong with server.accept()! " + e);
                    System.exit(1);
                    return;
                }
            }
        }.start();
    }

    public static void main(String[] args) {
        String configurationPathname = "";
        int refresh = 0;
        if (args.length == 0) {
            System.out.println("StoRMCommandServer invoked without any command line parameter.");
        } else if (args.length == 2) {
            configurationPathname = args[0];
            System.out.println("StoRMCommandServer invoked with two parameters.");
            System.out.println("Configuration file: " + configurationPathname);
            try {
                refresh = Integer.parseInt(args[1]);
                System.out.println("Configuration file refresh rate: " + refresh + " seconds");
            }
            catch (NumberFormatException e) {
                System.out.println("Configuration file refresh rate: NOT an integer! Disabling refresh by default!");
            }
        } else {
            System.out.print("StoRMCommandServer invoked with an invalid number of parameters. ");
            System.out.println("Ignoring all: continuing as though as none were present.");
        }
        System.out.println("Now booting StoRM...");
        new StoRMCommandServer(new StoRM(configurationPathname, refresh));
    }

    private class CommandExecuterThread
    extends Thread {
        private static final String REQUEST_SUCCESS_RESPONSE = "SUCCESS";
        private static final String REQUEST_FAILURE_RESPONSE = "FAILURE";
        private static final String REQUEST_WARNING_RESPONSE = "WARNING";
        private Socket socket;

        private CommandExecuterThread(Socket socket, StoRM storm) {
            this.socket = socket;
        }

        @Override
        public void run() {
            String inputLine;
            BufferedWriter out;
            BufferedReader in;
            try {
                in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            }
            catch (IOException e) {
                log.error("UNEXPECTED ERROR! Unable to get a reader for the client socket. IOException : " + e.getMessage());
                return;
            }
            try {
                out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            }
            catch (IOException e) {
                log.error("UNEXPECTED ERROR! Unable to get a writer for the client socket. IOException : " + e.getMessage());
                return;
            }
            String response = REQUEST_FAILURE_RESPONSE;
            boolean acceptCommands = true;
            try {
                inputLine = in.readLine();
            }
            catch (IOException e) {
                log.error("UNEXPECTED ERROR! Unable to read from the client socket. IOException : " + e.getMessage());
                return;
            }
            if (inputLine != null) {
                do {
                    block4 : switch (Command.getCommand(inputLine)) {
                        case START: {
                            log.info("StoRM: starting Backend services...");
                            if (this.startServices()) {
                                response = REQUEST_SUCCESS_RESPONSE;
                                log.info("StoRM: Backend services successfully started.");
                                break;
                            }
                            log.error("StoRM: error starting storm services.");
                            break;
                        }
                        case STOP: {
                            log.info("StoRM: stopping Backend services...");
                            if (this.stopServices()) {
                                response = REQUEST_SUCCESS_RESPONSE;
                                log.info("StoRM: Backend successfully stopped.");
                                break;
                            }
                            log.error("StoRM: error stopping storm services.");
                            break;
                        }
                        case SHUTDOWN: {
                            if (!StoRMCommandServer.this.shutdownInProgress) {
                                StoRMCommandServer.this.shutdownInProgress = true;
                                log.info("StoRM: Backend shutdown...");
                                log.info("StoRM: stopping Backend services...");
                                this.stopServices();
                                response = REQUEST_SUCCESS_RESPONSE;
                                this.sendOutputAndClose(response, out, in, this.socket);
                                log.info("StoRM: Backend shutdown complete.");
                                System.exit(0);
                            }
                            log.info("StoRM: Backend shutdown already in progress");
                            break;
                        }
                        case STATUS: {
                            switch (this.getCurrentStatus()) {
                                case RUNNING: {
                                    response = StormStatus.RUNNING.getStatusMessage();
                                    break block4;
                                }
                                case STOPPED: {
                                    response = StormStatus.STOPPED.getStatusMessage();
                                    break block4;
                                }
                                case STARTING: {
                                    response = StormStatus.STARTING.getStatusMessage();
                                    break block4;
                                }
                                case STOPPING: {
                                    response = StormStatus.STOPPING.getStatusMessage();
                                    break block4;
                                }
                                case SHUTTING_DOWN: {
                                    response = StormStatus.SHUTTING_DOWN.getStatusMessage();
                                    break block4;
                                }
                                case UNKNOW: {
                                    response = REQUEST_WARNING_RESPONSE;
                                    break block4;
                                }
                            }
                            response = REQUEST_WARNING_RESPONSE;
                            break;
                        }
                        case EXIT: {
                            break;
                        }
                        case UNKNOW: {
                            log.warn("Received an unknown command: " + inputLine);
                            acceptCommands = false;
                            break;
                        }
                        default: {
                            acceptCommands = false;
                            log.warn("Received an unknown command: " + inputLine);
                        }
                    }
                    try {
                        inputLine = in.readLine();
                    }
                    catch (IOException e) {
                        log.error("UNEXPECTED ERROR! Unable to read from the client socket. IOException : " + e.getMessage());
                        return;
                    }
                } while (inputLine != null && acceptCommands);
            }
            this.sendOutputAndClose(response, out, in, this.socket);
        }

        private boolean startServices() {
            boolean response = true;
            if (!StoRMCommandServer.this.storm.pickerIsRunning()) {
                StoRMCommandServer.this.storm.startPicker();
            }
            try {
                if (!StoRMCommandServer.this.storm.xmlRpcServerIsRunning()) {
                    StoRMCommandServer.this.storm.startXmlRpcServer();
                }
            }
            catch (Exception e) {
                log.error("Unable to start the xmlrpc server. Exception: " + e.getMessage());
                this.stopServices();
                return false;
            }
            try {
                if (!StoRMCommandServer.this.storm.restServerIsRunning()) {
                    StoRMCommandServer.this.storm.startRestServer();
                }
            }
            catch (Exception e) {
                log.error("Unable to start the Rest server. Exception: " + e.getMessage());
                this.stopServices();
                return false;
            }
            if (!StoRMCommandServer.this.storm.spaceGCIsRunning()) {
                StoRMCommandServer.this.storm.startSpaceGC();
            }
            return response;
        }

        private boolean stopServices() {
            boolean response = true;
            StoRMCommandServer.this.storm.stopPicker();
            StoRMCommandServer.this.storm.stopXmlRpcServer();
            StoRMCommandServer.this.storm.stopRestServer();
            StoRMCommandServer.this.storm.stopSpaceGC();
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendOutputAndClose(String response, BufferedWriter out, BufferedReader in, Socket socket) {
            try {
                try {
                    out.write(response, 0, response.length());
                    out.newLine();
                }
                catch (IOException e) {
                    log.error("UNEXPECTED ERROR! Unable to write on the client socket. IOException : " + e.getMessage());
                }
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    log.error("UNEXPECTED ERROR! Unable to close client socket streams. IOException : " + e.getMessage());
                }
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error("UNEXPECTED ERROR! Unable to close client socket. IOException : " + e.getMessage());
                }
            }
        }

        private StormStatus getCurrentStatus() {
            if (this.bootstrapInProgress()) {
                return StormStatus.BOOTSTRAPPING;
            }
            if (this.shutdownInProgress()) {
                return StormStatus.SHUTTING_DOWN;
            }
            if (this.servicesRunning()) {
                return StormStatus.RUNNING;
            }
            if (this.servicesStopped()) {
                return StormStatus.STOPPED;
            }
            if (this.servicesStarting()) {
                return StormStatus.STARTING;
            }
            if (this.servicesStopping()) {
                return StormStatus.STOPPING;
            }
            return StormStatus.UNKNOW;
        }

        private boolean bootstrapInProgress() {
            return false;
        }

        private boolean shutdownInProgress() {
            return StoRMCommandServer.this.shutdownInProgress;
        }

        private boolean servicesRunning() {
            return StoRMCommandServer.this.storm.pickerIsRunning() && StoRMCommandServer.this.storm.xmlRpcServerIsRunning() && StoRMCommandServer.this.storm.restServerIsRunning() && StoRMCommandServer.this.storm.spaceGCIsRunning();
        }

        private boolean servicesStopped() {
            return !StoRMCommandServer.this.storm.pickerIsRunning() && !StoRMCommandServer.this.storm.xmlRpcServerIsRunning() && !StoRMCommandServer.this.storm.restServerIsRunning() && !StoRMCommandServer.this.storm.spaceGCIsRunning();
        }

        private boolean servicesStarting() {
            return false;
        }

        private boolean servicesStopping() {
            return false;
        }
    }

    private static enum StormStatus {
        BOOTSTRAPPING("BOOTSTRAPPING"),
        RUNNING("RUNNING"),
        STOPPED("STOPPED"),
        STARTING("STARTING"),
        STOPPING("STOPPING"),
        SHUTTING_DOWN("SHUTTING_DOWN"),
        UNKNOW("UNKNOW");

        private final String statusMessage;

        private StormStatus(String name) {
            this.statusMessage = name;
        }

        private String getStatusMessage() {
            return this.statusMessage;
        }

        public String toString() {
            return this.statusMessage;
        }
    }

    private static enum Command {
        START("START"),
        STOP("STOP"),
        SHUTDOWN("SHUTDOWN"),
        STATUS("STATUS"),
        EXIT("EXIT"),
        UNKNOW("UNKNOW");

        private final String name;

        private Command(String name) {
            this.name = name;
        }

        public static Command getCommand(String name) {
            if (name != null) {
                for (Command command : Command.values()) {
                    if (!command.getName().equals(name.trim().toUpperCase())) continue;
                    return command;
                }
            }
            return UNKNOW;
        }

        private String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

