/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm;

import it.grid.storm.asynch.AdvancedPicker;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.SimpleCheckManager;
import it.grid.storm.config.ConfigReader;
import it.grid.storm.config.Configuration;
import it.grid.storm.config.WelcomeMessage;
import it.grid.storm.health.HealthDirector;
import it.grid.storm.logging.StoRMLoggers;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.rest.RestService;
import it.grid.storm.startup.Bootstrap;
import it.grid.storm.startup.BootstrapException;
import it.grid.storm.xmlrpc.StoRMXmlRpcException;
import it.grid.storm.xmlrpc.XMLRPCHttpServer;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoRM {
    private AdvancedPicker picker = null;
    private XMLRPCHttpServer xmlrpcServer = null;
    private final String welcome = WelcomeMessage.getWelcomeMessage();
    private static Logger log;
    private final Timer GC = new Timer();
    private final ReservedSpaceCatalog spaceCatalog;
    private TimerTask cleaningTask = null;
    private boolean isPickerRunning = false;
    private boolean isXmlrpcServerRunning = false;
    private boolean isRestServerRunning = false;
    private boolean isSpaceGCRunning = false;

    public StoRM(String configurationPathname, int refresh) {
        if (configurationPathname == null || configurationPathname.equals("")) {
            configurationPathname = "/opt/storm/backend/etc/storm.properties";
            System.out.print("This instance of StoRM Backend was invoked without explicitly specifying ");
            System.out.print("a configuration file. Looking for the standard one in ");
            System.out.println(configurationPathname);
        } else {
            System.out.print("Looking for configuration file ");
            System.out.println(configurationPathname);
        }
        Configuration.getInstance().setConfigReader(new ConfigReader(configurationPathname, refresh));
        String currentConfig = "\nCurrent configuration:\n" + Configuration.getInstance().toString();
        System.out.println(currentConfig);
        System.out.println("\n" + this.welcome);
        this.spaceCatalog = new ReservedSpaceCatalog();
        String configurationDir = Configuration.getInstance().configurationDir();
        String logFile = configurationDir + "logging.xml";
        Bootstrap.initializeLogging(logFile);
        log = LoggerFactory.getLogger(StoRM.class);
        log.warn(this.welcome);
        log.info(currentConfig);
        boolean verboseMode = false;
        boolean testingMode = false;
        NamespaceDirector.initializeDirector(verboseMode, testingMode);
        HealthDirector.initializeDirector(false);
        String pathAuthzDBFileName = configurationDir + "path-authz.db";
        try {
            Bootstrap.initializePathAuthz(pathAuthzDBFileName);
        }
        catch (BootstrapException e) {
            log.error("Unable to initialize the Path Authorization manager. BootstrapException: " + e.getMessage());
            throw new RuntimeException("Unable to initialize the Path Authorization manager");
        }
        Bootstrap.initializeUsedSpace();
        if (Configuration.getInstance().getGridhttpsEnabled()) {
            log.info("Initializing the https plugin");
            String httpsFactoryName = Configuration.getInstance().getGRIDHTTPSPluginClassName();
            Bootstrap.initializeAclManager(httpsFactoryName, LoggerFactory.getLogger(Bootstrap.class));
        }
        this.picker = new AdvancedPicker();
        try {
            this.xmlrpcServer = new XMLRPCHttpServer(Configuration.getInstance().getXmlRpcServerPort(), Configuration.getInstance().getMaxXMLRPCThread());
        }
        catch (StoRMXmlRpcException e) {
            log.error("Unable to create the XML-RPC Server. StoRMXmlRpcException: " + e.getMessage());
            throw new RuntimeException("Unable to create the XML-RPC Server");
        }
        if (Configuration.getInstance().getSanityCheckEnabled()) {
            SimpleCheckManager checkManager = new SimpleCheckManager();
            checkManager.init();
            CheckResponse checkResponse = checkManager.lauchChecks();
            if (checkResponse.isSuccessfull()) {
                log.info("Check suite executed successfully");
            } else {
                if (checkResponse.getStatus().equals((Object)CheckStatus.CRITICAL_FAILURE)) {
                    log.error("Storm Check suite is failed for some critical checks!");
                    StoRMLoggers.getStderrLogger().error("Storm Check suite is failed for some critical checks! Please check the log for more details");
                    throw new RuntimeException("Storm Check suite is failed for some critical checks! Please check the log for more details");
                }
                log.warn("Storm Check suite is failed but not for any critical check. StoRM safely started.");
                StoRMLoggers.getStderrLogger().error("Storm Check suite is failed but not for any critical check. StoRM safely started. Please check the log for more details");
            }
        } else {
            log.warn("Sanity checks disabled. Unable to determine if the environment is sane");
        }
    }

    public synchronized void startPicker() {
        this.picker.startIt();
        this.isPickerRunning = true;
    }

    public synchronized void stopPicker() {
        this.picker.stopIt();
        this.isPickerRunning = false;
    }

    public synchronized boolean pickerIsRunning() {
        return this.isPickerRunning;
    }

    public synchronized void startXmlRpcServer() throws Exception {
        this.xmlrpcServer.start();
        this.isXmlrpcServerRunning = true;
    }

    public synchronized void stopXmlRpcServer() {
        this.xmlrpcServer.stop();
        this.isXmlrpcServerRunning = false;
    }

    public synchronized boolean xmlRpcServerIsRunning() {
        return this.isXmlrpcServerRunning;
    }

    public synchronized void startRestServer() throws Exception {
        try {
            RestService.startServer();
        }
        catch (IOException e) {
            System.err.println("Unable to start internal HTTP Server listening for RESTFul services. IOException : " + e.getMessage());
            throw new Exception("Unable to start internal HTTP Server listening for RESTFul services. IOException : " + e.getMessage());
        }
        this.isRestServerRunning = true;
    }

    public synchronized void stopRestServer() {
        RestService.stop();
        this.isRestServerRunning = false;
    }

    public synchronized boolean restServerIsRunning() {
        return this.isRestServerRunning;
    }

    public synchronized void startSpaceGC() {
        log.debug("Starting Space GC.");
        long delay = Configuration.getInstance().getCleaningInitialDelay() * 1000L;
        long period = Configuration.getInstance().getCleaningTimeInterval() * 1000L;
        this.cleaningTask = new TimerTask(){

            @Override
            public void run() {
                StoRM.this.spaceCatalog.purge();
            }
        };
        this.GC.scheduleAtFixedRate(this.cleaningTask, delay, period);
        this.isSpaceGCRunning = true;
        log.debug("Space GC started.");
    }

    public synchronized void stopSpaceGC() {
        log.debug("Stopping Space GC.");
        if (this.cleaningTask != null) {
            this.cleaningTask.cancel();
            this.GC.purge();
        }
        log.debug("Space GC stopped.");
        this.isSpaceGCRunning = false;
    }

    public synchronized boolean spaceGCIsRunning() {
        return this.isSpaceGCRunning;
    }
}

