/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger log;
    public static Entry BE_VERSION;
    public static final Entry NAMESPACE_VERSION;
    public static final Entry BE_OS_DISTRIBUTION;
    public static final Entry BE_OS_PLATFORM;
    public static final Entry BE_OS_KERNEL_RELEASE;
    private static String distribution;
    private static String platform;
    private static String kernelRelease;
    private static final String notAvailable = "N/A";

    private static void parseVersionInStream(Properties prop) {
        String version = prop.getProperty("VERSION", notAvailable);
        String age = prop.getProperty("RELEASE", notAvailable);
        String svnRevision = prop.getProperty("svn.revision.number", notAvailable);
        String buildDate = prop.getProperty("build.date", notAvailable);
        BE_VERSION = new Entry("BE-Version", version + "-" + age);
        log.debug("SVN-Revision : " + svnRevision);
        log.debug("Build Date   : " + buildDate);
    }

    public static String getDistribution() {
        if (distribution == null) {
            Constants.populateDistribution();
        }
        return distribution;
    }

    public static String getPlatform() {
        if (platform == null) {
            Constants.populatePlatformKernel();
        }
        return platform;
    }

    public static String getKernelRelease() {
        if (kernelRelease == null) {
            Constants.populatePlatformKernel();
        }
        return kernelRelease;
    }

    private static void populateDistribution() {
        distribution = notAvailable;
        String issuePath = File.separatorChar + "etc" + File.separatorChar + "issue";
        File issueFile = new File(issuePath);
        if (!(issueFile.exists() && issueFile.isFile() && issueFile.canRead())) {
            log.warn("Unable to read " + issueFile.getAbsolutePath() + " file!!");
        } else {
            try {
                BufferedReader issueReader = new BufferedReader(new FileReader(issueFile));
                String output = issueReader.readLine();
                if (output == null) {
                    log.warn("The file " + issueFile.getAbsolutePath() + " is empty!");
                } else {
                    distribution = output;
                }
            }
            catch (FileNotFoundException e) {
                log.error("Unable to read file '" + issueFile.getAbsolutePath() + "'. " + e);
            }
            catch (IOException e) {
                log.error("Unable to read file '" + issueFile.getAbsolutePath() + "'." + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populatePlatformKernel() {
        try {
            Process p = Runtime.getRuntime().exec("uname -ri");
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String error2 = stdError.readLine();
            String output = stdInput.readLine();
            if (output == null || stdInput.read() != -1 || error2 != null) {
                while (error2 != null) {
                    error2 = error2 + stdError.readLine();
                }
                log.error("Unable to invoke 'uname -ri' . Standard error : " + error2);
            } else {
                String[] fields = output.trim().split(" ");
                kernelRelease = fields[0];
                platform = fields[1];
            }
        }
        catch (IOException e) {
            log.error("Unable to invoke 'uname -ri' . IOException " + e);
        }
        finally {
            if (distribution == null) {
                platform = notAvailable;
                kernelRelease = notAvailable;
            }
        }
    }

    static {
        String VERSIONResourcePath;
        InputStream inStream;
        log = LoggerFactory.getLogger(Constants.class);
        BE_VERSION = new Entry("BE-Version", ">=1.5.3 (manual building)");
        NAMESPACE_VERSION = new Entry("Namespace-version", "1.5.0");
        BE_OS_DISTRIBUTION = new Entry("BE-OS-Distribution", Constants.getDistribution());
        BE_OS_PLATFORM = new Entry("BE-OS-Platform", Constants.getPlatform());
        BE_OS_KERNEL_RELEASE = new Entry("BE-OS-Kernel-Release", Constants.getKernelRelease());
        distribution = null;
        platform = null;
        kernelRelease = null;
        ClassLoader loader = Constants.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((inStream = loader.getResourceAsStream(VERSIONResourcePath = "it" + File.separatorChar + "grid" + File.separatorChar + "storm" + File.separatorChar + "VERSION")) == null) {
            log.warn("No " + VERSIONResourcePath + " file available in resource path. Using the default values (NOT IN PRODUCTION!). Maybe you are using StoRM built without the original ANT.");
        } else {
            Properties versioningroperties = new Properties();
            try {
                versioningroperties.load(inStream);
            }
            catch (IOException e) {
                log.warn("Unable to retrieve the VERSION property file.");
            }
            Constants.parseVersionInStream(versioningroperties);
        }
    }

    public static class Entry {
        private final String key;
        private final String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

