/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.common.CoGProperties;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.util.Base64;
import org.globus.util.I18n;
import org.globus.util.PEMUtils;

public class CertUtil {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$CertUtil == null ? (class$org$globus$gsi$CertUtil = CertUtil.class$("org.globus.gsi.CertUtil")) : class$org$globus$gsi$CertUtil).getName());
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", (class$org$globus$gsi$CertUtil == null ? (class$org$globus$gsi$CertUtil = CertUtil.class$("org.globus.gsi.CertUtil")) : class$org$globus$gsi$CertUtil).getClassLoader());
    private static String provider;
    static /* synthetic */ Class class$org$globus$gsi$CertUtil;

    public static void init() {
    }

    public static void setProvider(String providerName) {
        provider = providerName;
        if (logger.isDebugEnabled()) {
            logger.debug("Provider set to : " + providerName);
        }
    }

    protected static CertificateFactory getCertificateFactory() throws GeneralSecurityException {
        if (provider == null) {
            return CertificateFactory.getInstance("X.509");
        }
        return CertificateFactory.getInstance("X.509", provider);
    }

    public static X509Certificate loadCertificate(InputStream in) throws GeneralSecurityException {
        return (X509Certificate)CertUtil.getCertificateFactory().generateCertificate(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException(i18n.getMessage("certFileNull"));
        }
        X509Certificate cert = null;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            cert = CertUtil.readCertificate(reader);
        }
        finally {
            reader.close();
        }
        if (cert == null) {
            throw new GeneralSecurityException(i18n.getMessage("noCertData"));
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] loadCertificates(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException(i18n.getMessage("certFileNull"));
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        X509Certificate cert = null;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            while ((cert = CertUtil.readCertificate(reader)) != null) {
                list.add(cert);
            }
        }
        finally {
            reader.close();
        }
        if (list.isEmpty()) {
            throw new GeneralSecurityException(i18n.getMessage("noCertData"));
        }
        int size = list.size();
        return list.toArray(new X509Certificate[size]);
    }

    public static X509Certificate readCertificate(BufferedReader reader) throws IOException, GeneralSecurityException {
        String line = null;
        StringBuffer buff = new StringBuffer();
        boolean isCert = false;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("BEGIN CERTIFICATE") != -1) {
                isCert = true;
                continue;
            }
            if (isCert && line.indexOf("END CERTIFICATE") != -1) {
                byte[] data = Base64.decode(buff.toString().getBytes());
                return CertUtil.loadCertificate(new ByteArrayInputStream(data));
            }
            if (!isCert) continue;
            buff.append(line);
        }
        return null;
    }

    public static void writeCertificate(OutputStream out, X509Certificate cert) throws IOException, CertificateEncodingException {
        PEMUtils.writeBase64(out, "-----BEGIN CERTIFICATE-----", Base64.encode(cert.getEncoded()), "-----END CERTIFICATE-----");
    }

    public static String toGlobusID(String dn) {
        return CertUtil.toGlobusID(dn, true);
    }

    public static String toGlobusID(String dn, boolean noreverse) {
        if (dn == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(dn, ",");
        StringBuffer buf = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (noreverse) {
                buf.append("/");
                buf.append(token);
                continue;
            }
            buf.insert(0, token);
            buf.insert(0, "/");
        }
        return buf.toString();
    }

    public static String toGlobusID(Principal name) {
        if (name instanceof X509Name) {
            return X509NameHelper.toString((X509Name)((Object)name));
        }
        return CertUtil.toGlobusID(name.getName());
    }

    public static void installSecureRandomProvider() {
        CoGProperties props = CoGProperties.getDefault();
        String providerName = props.getSecureRandomProvider();
        try {
            logger.debug("Loading SecureRandom provider: " + providerName);
            Class<?> providerClass = Class.forName(providerName);
            Security.insertProviderAt((Provider)providerClass.newInstance(), 1);
        }
        catch (Exception e) {
            logger.debug("Unable to install PRNG. Using default PRNG.", e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm, int bits) throws GeneralSecurityException {
        KeyPairGenerator generator = null;
        generator = provider == null ? KeyPairGenerator.getInstance(algorithm) : KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize(bits);
        return generator.generateKeyPair();
    }

    public static boolean isProxy(int certType) {
        return CertUtil.isGsi2Proxy(certType) || CertUtil.isGsi3Proxy(certType) || CertUtil.isGsi4Proxy(certType);
    }

    public static boolean isGsi4Proxy(int certType) {
        return certType == 18 || certType == 17 || certType == 16 || certType == 19;
    }

    public static boolean isGsi3Proxy(int certType) {
        return certType == 14 || certType == 13 || certType == 12 || certType == 15;
    }

    public static boolean isGsi2Proxy(int certType) {
        return certType == 10 || certType == 11;
    }

    public static boolean isLimitedProxy(int certType) {
        return certType == 15 || certType == 11 || certType == 19;
    }

    public static boolean isIndependentProxy(int certType) {
        return certType == 13 || certType == 17;
    }

    public static boolean isImpersonationProxy(int certType) {
        return certType == 14 || certType == 15 || certType == 18 || certType == 19 || certType == 11 || certType == 10;
    }

    public static String getProxyTypeAsString(int proxyType) {
        switch (proxyType) {
            case 18: {
                return "RFC 3820 compliant impersonation proxy";
            }
            case 17: {
                return "RFC 3820 compliant independent proxy";
            }
            case 19: {
                return "RFC 3820 compliant limited proxy";
            }
            case 16: {
                return "RFC 3820 compliant restricted proxy";
            }
            case 14: {
                return "Proxy draft compliant impersonation proxy";
            }
            case 13: {
                return "Proxy draft compliant independent proxy";
            }
            case 15: {
                return "Proxy draft compliant limited proxy";
            }
            case 12: {
                return "Proxy draft compliant restricted proxy";
            }
            case 10: {
                return "full legacy globus proxy";
            }
            case 11: {
                return "limited legacy globus proxy";
            }
        }
        return "not a proxy";
    }

    public static boolean isGsi3Enabled() {
        String ver = System.getProperty("org.globus.gsi.version");
        return ver != null && ver.equals("3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509CRL loadCrl(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            throw new IllegalArgumentException(i18n.getMessage("crlFileNull"));
        }
        boolean isCrl = false;
        X509CRL crl = null;
        BufferedReader reader = null;
        String line = null;
        StringBuffer buff = new StringBuffer();
        reader = new BufferedReader(new FileReader(file));
        try {
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("BEGIN X509 CRL") != -1) {
                    isCrl = true;
                    continue;
                }
                if (isCrl && line.indexOf("END X509 CRL") != -1) {
                    byte[] data = Base64.decode(buff.toString().getBytes());
                    crl = CertUtil.loadCrl(new ByteArrayInputStream(data));
                    continue;
                }
                if (!isCrl) continue;
                buff.append(line);
            }
        }
        finally {
            reader.close();
        }
        if (crl == null) {
            throw new GeneralSecurityException(i18n.getMessage("noCrlData"));
        }
        return crl;
    }

    public static X509CRL loadCrl(InputStream in) throws GeneralSecurityException {
        return (X509CRL)CertUtil.getCertificateFactory().generateCRL(in);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        CertUtil.setProvider("BC");
        CertUtil.installSecureRandomProvider();
    }
}

