/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.util.http.LineReader;

public class JobRequestParser {
    protected LineReader _reader = null;
    protected String _callbackURL = null;
    protected String _rsl = null;
    protected int _stateMask = 0;

    public JobRequestParser(InputStream in) {
        this._reader = new LineReader(in);
    }

    public JobRequestParser(LineReader reader) {
        this._reader = reader;
    }

    public String getRSL() {
        return this._rsl;
    }

    public int getJobStateMask() {
        return this._stateMask;
    }

    public String getCallbackURL() {
        return this._callbackURL;
    }

    private String getValueForToken(String expected) throws JobManagerException {
        String line = null;
        try {
            line = this._reader.readLine();
        }
        catch (IOException e) {
            throw new JobManagerException("io problems");
        }
        if (line != null && !line.regionMatches(true, 0, expected, 0, expected.length())) {
            throw new JobManagerException("bad request");
        }
        return JobRequestParser.getRest(line, expected.length());
    }

    public void parse() throws JobManagerException {
        String value = null;
        value = this.getValueForToken("protocol-version: ");
        if (!value.equals(String.valueOf(2))) {
            throw new JobManagerException(49);
        }
        value = this.getValueForToken("job-state-mask: ");
        try {
            this._stateMask = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new JobManagerException("bad state mask");
        }
        this._callbackURL = value = this.getValueForToken("callback-url: ");
        this._rsl = value = this.getValueForToken("rsl: ");
    }

    protected static final String getRest(String line, int index) {
        return line.substring(index).trim();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job Request: ").append("RSL: ").append(this._rsl).append(", ").append("Client contact: ").append(this._callbackURL).append(", ").append("Job status mask: ").append(String.valueOf(this._stateMask));
        return buf.toString();
    }
}

