/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager.internal;

import java.io.IOException;
import java.io.InputStream;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobManagerService;
import org.globus.util.Util;
import org.globus.util.http.HTTPRequestParser;

public class JobManagerRequest
extends HTTPRequestParser {
    private JobManagerService _jobManager;

    public JobManagerRequest(JobManagerService jobManager, InputStream in) throws IOException, JobManagerException {
        super(in);
        this.setJobManager(jobManager);
        this.parseRequest();
    }

    public void setJobManager(JobManagerService jobManager) {
        this._jobManager = jobManager;
    }

    public void parseRequest() throws IOException, JobManagerException {
        String line = null;
        line = this.getValueForToken("protocol-version: ");
        if (!line.equals(String.valueOf(2))) {
            throw new JobManagerException(49);
        }
        line = this._reader.readLine();
        try {
            line = Util.unquote((String)line);
        }
        catch (Exception e) {
            throw new JobManagerException("bad request");
        }
        if (line.regionMatches(true, 0, "cancel", 0, "cancel".length())) {
            this._jobManager.cancel();
        } else if (!line.regionMatches(true, 0, "status", 0, "status".length())) {
            if (line.regionMatches(true, 0, "register", 0, "register".length())) {
                int pos = (line = JobManagerRequest.getRest((String)line, (int)"register".length())).indexOf(" ");
                if (pos == -1) {
                    throw new JobManagerException(91);
                }
                int stateMask = 0;
                try {
                    stateMask = Integer.parseInt(line.substring(0, pos).trim());
                }
                catch (Exception e) {
                    throw new JobManagerException(91);
                }
                this._jobManager.register(line.substring(pos + 1), stateMask);
            } else if (line.regionMatches(true, 0, "unregister", 0, "unregister".length())) {
                line = JobManagerRequest.getRest((String)line, (int)"unregister".length());
                this._jobManager.unregister(line);
            } else if (line.regionMatches(true, 0, "signal", 0, "signal".length())) {
                int pos = (line = JobManagerRequest.getRest((String)line, (int)"signal".length())).indexOf(" ");
                if (pos == -1) {
                    throw new JobManagerException(91);
                }
                int signal = 0;
                try {
                    signal = Integer.parseInt(line.substring(0, pos).trim());
                }
                catch (Exception e) {
                    throw new JobManagerException(91);
                }
                this._jobManager.signal(signal, line.substring(pos + 1));
            } else {
                throw new JobManagerException(92);
            }
        }
    }

    private String getValueForToken(String expected) throws IOException, JobManagerException {
        String line = this._reader.readLine();
        if (line != null && !line.regionMatches(true, 0, expected, 0, expected.length())) {
            throw new JobManagerException("bad request");
        }
        return JobManagerRequest.getRest((String)line, (int)expected.length());
    }
}

