/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.globus.gatekeeper.jobmanager.AbstractJobManager;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobRequest;
import org.globus.rsl.RslAttributes;

public class ShellJobManager
extends AbstractJobManager {
    private static final String SCRIPT_JOB_ID = "GRAM_SCRIPT_JOB_ID:";
    private static final String SCRIPT_SUCCESS = "GRAM_SCRIPT_SUCCESS:";
    private static final String SCRIPT_ERROR = "GRAM_SCRIPT_ERROR:";
    private static final int STATUS_POLL_FREQUENCY = 5000;
    private StatusThread _statusThread = null;
    private String _type;
    private String _libExecDir;
    private File _directory;
    private File argFile = null;

    public ShellJobManager() {
        this.allowStdioUrls = false;
    }

    public void setLibExecDirectory(String libExecDirectory) {
        this._libExecDir = libExecDirectory;
    }

    public void setType(String type) {
        this._type = type;
    }

    private void runScript(String scriptType) throws JobManagerException {
        this.runScript(scriptType, null);
    }

    private void runScript(String scriptType, String arg) throws JobManagerException {
        if (this._type == null) {
            throw new JobManagerException(66, "JobManager type was not set");
        }
        if (this._libExecDir == null) {
            throw new JobManagerException(66, "JobManager libexec directory was not set");
        }
        if (scriptType == null) {
            throw new JobManagerException(66, "JobManager script name was not set");
        }
        String[] cmd = new String[arg == null ? 2 : 3];
        cmd[0] = this._libExecDir + "/globus-script-" + this._type + "-" + scriptType;
        cmd[1] = this.argFile.getAbsolutePath();
        if (arg != null) {
            cmd[2] = arg;
        }
        this.runScript(cmd);
    }

    private void runScript(String[] cmd) throws JobManagerException {
        String line = null;
        try {
            Process process = Runtime.getRuntime().exec(cmd, this.getEnvArray(), this._directory);
            InputStream out = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(out));
            while ((line = reader.readLine()) != null) {
                if (this._jobLogger.isDebugEnabled()) {
                    this._jobLogger.debug((Object)("SCRIPT OUTPUT: " + line));
                }
                if (line.startsWith(SCRIPT_JOB_ID)) continue;
                if (line.startsWith(SCRIPT_SUCCESS)) {
                    String value = line.substring(SCRIPT_SUCCESS.length()).trim();
                    try {
                        this.setStatus(Integer.parseInt(value));
                    }
                    catch (Exception e) {
                        throw new JobManagerException(25, (Throwable)e);
                    }
                    return;
                }
                if (!line.startsWith(SCRIPT_ERROR)) continue;
                String value = line.substring(SCRIPT_ERROR.length()).trim();
                int fc = 0;
                try {
                    fc = Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new JobManagerException(25, (Throwable)e);
                }
                throw new JobManagerException(fc);
            }
            throw new JobManagerException(24);
        }
        catch (Exception e) {
            throw new JobManagerException(66, (Throwable)e);
        }
    }

    public void cancel() throws JobManagerException {
        this.runScript("rm");
        this.setStatus(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void signal(int signal, String args) throws JobManagerException {
        File signalFile;
        block6: {
            PrintWriter writer = null;
            signalFile = null;
            try {
                signalFile = File.createTempFile("grami_signal", ".tmp");
                this.fileList.add(signalFile);
                writer = new PrintWriter(new FileOutputStream(signalFile));
            }
            catch (IOException e) {
                throw new JobManagerException(22);
            }
            writer.println(this.write("grami_signal_arg", args));
            writer.println(this.write("grami_signal", signal));
            writer.close();
            if (writer.checkError()) {
                throw new JobManagerException(22);
            }
            try {
                this.runScript("signal", signalFile.getAbsolutePath());
                Object var7_6 = null;
                if (signal != 1) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (signal == 1) {
                    this.setStatus(4);
                }
                signalFile.delete();
                throw throwable;
            }
            this.setStatus(4);
        }
        signalFile.delete();
    }

    public void request(JobRequest request) throws JobManagerException {
        PrintWriter writer = null;
        try {
            this.argFile = File.createTempFile("grami", ".tmp");
            this.fileList.add(this.argFile);
            writer = new PrintWriter(new FileOutputStream(this.argFile));
        }
        catch (IOException e) {
            throw new JobManagerException(22);
        }
        this.writeRequest(writer, request);
        writer.close();
        if (writer.checkError()) {
            throw new JobManagerException(22);
        }
        if (request.isDryRun()) {
            throw new JobManagerException(41);
        }
        this._directory = request.getDirectory();
        this.runScript("submit");
        if (this._status == 2 || this._status == 1) {
            this._statusThread = new StatusThread();
            this._statusThread.start();
        }
    }

    private void writeRequest(PrintWriter writer, JobRequest request) {
        RslAttributes rsl = request.getRsl();
        writer.println(this.write("grami_logfile", rsl.getSingle("scriptLogFile")));
        writer.println(this.write("grami_directory", request.getDirectory().getAbsolutePath()));
        writer.println(this.write("grami_program", request.getExecutable()));
        writer.println(this.write("grami_args", rsl.getMulti("arguments")));
        writer.println(this.write("grami_env", rsl.getMap("environment")));
        writer.println(this.write("grami_count", request.getCount()));
        writer.println(this.write("grami_stdin", request.getStdin()));
        writer.println(this.write("grami_stdout", request.getStdout(), "/dev/null"));
        writer.println(this.write("grami_stderr", request.getStderr(), "/dev/null"));
        writer.println(this.write("grami_max_wall_time", request.getMaxWallTime()));
        writer.println(this.write("grami_max_cpu_time", request.getMaxCpuTime()));
        writer.println(this.write("grami_start_time", (String)null));
        writer.println(this.write("grami_min_memory", request.getMinMemory()));
        writer.println(this.write("grami_max_memory", request.getMaxMemory()));
        writer.println(this.write("grami_host_count", request.getHostCount()));
        writer.println(this.write("grami_job_type", request.getJobType()));
        writer.println(this.write("grami_queue", (String)null));
        writer.println(this.write("grami_project", (String)null));
        writer.println(this.write("grami_reservation_handle", (String)null));
    }

    private String write(String attrib, int value) {
        return this.write(attrib, String.valueOf(value), null);
    }

    private String write(String attrib, long value) {
        return this.write(attrib, String.valueOf(value), null);
    }

    private String write(String attrib, String value) {
        return this.write(attrib, value, null);
    }

    private String write(String attrib, String value, String defValue) {
        StringBuffer buf = new StringBuffer(attrib);
        buf.append("='");
        String string = value = value == null ? defValue : value;
        if (value != null) {
            buf.append(this.encode(value));
        }
        buf.append("'");
        return buf.toString();
    }

    private String write(String attrib, List values) {
        StringBuffer buf = new StringBuffer(attrib);
        buf.append("='");
        if (values != null) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                buf.append("\"");
                buf.append(this.encode((String)iter.next()));
                buf.append("\" ");
            }
        }
        buf.append("'");
        return buf.toString();
    }

    private String write(String attrib, Map values) {
        StringBuffer buf = new StringBuffer(attrib);
        buf.append("='");
        if (values != null) {
            Iterator iter = values.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                buf.append("\"");
                buf.append(name);
                buf.append("\" \"");
                buf.append(values.get(name));
                buf.append("\" ");
            }
        }
        buf.append("'");
        return buf.toString();
    }

    private StringBuffer encode(String value) {
        int size = value.length();
        StringBuffer buf = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            char ch = value.charAt(i);
            if (ch == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (ch == '$') {
                buf.append("'\"\\\\$\"'");
                continue;
            }
            if (ch == '\\') {
                buf.append("\\\\\\\\");
                continue;
            }
            if (ch == '\'') {
                buf.append("'\"'\"'");
                continue;
            }
            buf.append(ch);
        }
        return buf;
    }

    public void dispose() {
        this._jobLogger.info((Object)"[shell] Cleaning up...");
        if (this._statusThread != null) {
            this._statusThread.stop();
        }
        super.dispose();
        this._statusThread = null;
    }

    class StatusThread
    implements Runnable {
        private boolean _stop = false;
        private int _frequency = 5000;

        StatusThread() {
        }

        public void start() {
            Thread d = new Thread(this);
            d.start();
        }

        public void stop() {
            this._stop = true;
        }

        public void run() {
            ShellJobManager.this._jobLogger.debug((Object)"[Shell status thread] running");
            this._stop = false;
            try {
                while (!this._stop) {
                    try {
                        Thread.sleep(this._frequency);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!this._stop) {
                        ShellJobManager.this.runScript("poll");
                        continue;
                    }
                    break;
                }
            }
            catch (JobManagerException jobManagerException) {
                // empty catch block
            }
            ShellJobManager.this._jobLogger.debug((Object)"[Shell status thread] done");
        }
    }
}

