/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.jobmanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.globus.gatekeeper.jobmanager.JobDoneListener;
import org.globus.gatekeeper.jobmanager.JobManager;
import org.globus.gatekeeper.jobmanager.JobManagerException;
import org.globus.gatekeeper.jobmanager.JobRequest;
import org.globus.gatekeeper.jobmanager.JobStatusListener;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.io.streams.FTPOutputStream;
import org.globus.io.streams.GassOutputStream;
import org.globus.io.streams.GridFTPOutputStream;
import org.globus.io.streams.HTTPOutputStream;
import org.globus.io.urlcopy.UrlCopy;
import org.globus.io.urlcopy.UrlCopyException;
import org.globus.rsl.RSLParser;
import org.globus.rsl.RslAttributes;
import org.globus.rsl.RslEvaluationException;
import org.globus.rsl.RslNode;
import org.globus.util.GlobusURL;
import org.globus.util.Tail;
import org.globus.util.Util;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;

public abstract class AbstractJobManager
implements JobManager {
    private static final String LOG_PATTERN = "%-5p: %m%n";
    private static final String[] ENV_VARIABLES = new String[]{"X509_CERT_DIR", "X509_USER_PROXY", "GLOBUS_GRAM_JOB_CONTACT", "GLOBUS_DEPLOY_PATH", "GLOBUS_INSTALL_PATH"};
    protected boolean appendStdout = true;
    protected List fileList;
    protected GSSCredential _credential = null;
    protected int _status = 0;
    protected int _failureCode = 0;
    protected Hashtable _callbackUrl;
    protected boolean allowStdioUrls = false;
    protected Tail _outputFollower;
    protected String _id = String.valueOf(this.hashCode());
    protected Properties _symbolTable = new Properties();
    protected JobDoneListener _jobDoneListener;
    protected Logger _jobLogger;

    public AbstractJobManager() {
        this._callbackUrl = new Hashtable();
        this.fileList = new LinkedList();
        this.initSymbolTable();
        this.initJobLogger();
    }

    protected void initJobLogger() {
        this._jobLogger = Logger.getLogger((String)(this.getClass().getName() + "." + this._id));
    }

    public void setLogFile() {
        File f = new File(System.getProperty("user.home"), "jgram_job_mgr_" + this._id + ".log");
        this.setLogFile(f.getAbsolutePath());
    }

    public void setLogFile(String file) {
        FileAppender ap = new FileAppender();
        ap.setFile(file);
        ap.setName("JobManager Log");
        ap.setLayout((Layout)new PatternLayout(LOG_PATTERN));
        ap.activateOptions();
        this._jobLogger.addAppender((Appender)ap);
    }

    public void setLogger(Logger logger) {
        this._jobLogger = logger;
    }

    public void setCredentials(GSSCredential credentials) {
        this._credential = credentials;
    }

    public GSSCredential getCredentials() {
        return this._credential;
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    protected void initSymbolTable() {
        this._symbolTable.put("HOME", System.getProperty("user.home"));
        this._symbolTable.put("LOGNAME", System.getProperty("user.name"));
        this._symbolTable.put("GLOBUS_HOST_OSNAME", System.getProperty("os.name"));
        this._symbolTable.put("GLOBUS_HOST_OSVERSION", System.getProperty("os.version"));
        AbstractJobManager.setGlobusProperties(this._symbolTable);
    }

    public static void setGlobusProperties(Map map) {
        String key = null;
        Properties props = System.getProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!key.regionMatches(true, 0, "GLOBUS", 0, 6)) continue;
            map.put(key, props.getProperty(key));
        }
    }

    public Properties getSymbolTable() {
        return this._symbolTable;
    }

    public Map getEnvironment() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < ENV_VARIABLES.length; ++i) {
            String value = this._symbolTable.getProperty(ENV_VARIABLES[i]);
            if (value == null) continue;
            map.put(ENV_VARIABLES[i], value);
        }
        return map;
    }

    public String[] getEnvArray() {
        return this.getEnvArray(null);
    }

    public String[] getEnvArray(Map map) {
        String name = null;
        Iterator iter = null;
        Map env = this.getEnvironment();
        if (map != null) {
            iter = map.keySet().iterator();
            while (iter.hasNext()) {
                name = (String)iter.next();
                if (env.get(name) != null) continue;
                env.put(name, map.get(name));
            }
        }
        int i = 0;
        String[] envArray = new String[env.size()];
        iter = env.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            envArray[i++] = name + "=" + env.get(name);
        }
        return envArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveDelegatedCredentials() throws JobManagerException {
        File proxyFile;
        block11: {
            if (this._credential == null) {
                throw new JobManagerException(29);
            }
            if (!(this._credential instanceof ExtendedGSSCredential)) {
                throw new JobManagerException(75);
            }
            proxyFile = null;
            try {
                proxyFile = File.createTempFile("x509up_", ".tmp");
            }
            catch (IOException e) {
                throw new JobManagerException(75);
            }
            this.fileList.add(proxyFile);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(proxyFile);
                    Util.setOwnerAccessOnly((String)proxyFile.getAbsolutePath());
                    byte[] data = ((ExtendedGSSCredential)this._credential).export(0);
                    out.write(data);
                }
                catch (Exception e) {
                    throw new JobManagerException(75, (Throwable)e);
                }
                Object var5_6 = null;
                if (out == null) break block11;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            out.close();
        }
        this._symbolTable.put("X509_USER_PROXY", proxyFile.getAbsolutePath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void request(String rslRequest) throws JobManagerException {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("Job request: " + rslRequest));
        }
        RslNode rslTree = null;
        try {
            rslTree = RSLParser.parse((String)Util.unquote((String)rslRequest));
        }
        catch (Exception e) {
            throw new JobManagerException(48, (Throwable)e);
        }
        JobRequest jobReq = new JobRequest();
        try {
            rslTree = (RslNode)rslTree.evaluate((Map)this.getSymbolTable());
        }
        catch (RslEvaluationException e) {
            throw new JobManagerException(39, (Throwable)e);
        }
        String tmpArg = null;
        RslAttributes rsl = new RslAttributes(rslTree);
        tmpArg = rsl.getSingle("debug");
        if (tmpArg != null && tmpArg.equalsIgnoreCase("yes")) {
            this.setLogFile();
        }
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("Final rsl: " + rslTree));
        }
        jobReq.setRslAttributes(rsl);
        try {
            File dir;
            tmpArg = rsl.getSingle("directory");
            if (tmpArg == null) {
                tmpArg = System.getProperty("user.home");
            }
            if (!(dir = new File(tmpArg)).exists() || dir.isFile()) {
                throw new JobManagerException(4);
            }
            jobReq.setDirectory(dir);
            tmpArg = rsl.getSingle("executable");
            if (tmpArg == null) {
                throw new JobManagerException(81);
            }
            if (tmpArg.indexOf("://") != -1) {
                tmpArg = this.stageExecutable(tmpArg);
            }
            File exec = null;
            exec = AbstractJobManager.isAbsolutePath(tmpArg) ? new File(tmpArg) : new File(dir, tmpArg);
            if (!exec.exists()) {
                throw new JobManagerException(5);
            }
            jobReq.setExecutable(exec.getAbsolutePath());
            int tmpInt = this.getAsInt(rsl.getSingle("count"), 1, 14);
            if (tmpInt < 1) {
                throw new JobManagerException(14);
            }
            jobReq.setCount(tmpInt);
            long tmpLong = this.getAsLong(rsl.getSingle("minMemory"), 0L, 86);
            if (tmpLong < 0L) {
                throw new JobManagerException(86);
            }
            jobReq.setMinMemory(tmpLong);
            tmpLong = this.getAsLong(rsl.getSingle("maxMemory"), 0L, 87);
            if (tmpLong < 0L) {
                throw new JobManagerException(87);
            }
            jobReq.setMaxMemory(tmpLong);
            tmpInt = this.getAsInt(rsl.getSingle("hostCount"), 1, 35);
            if (tmpInt < 1) {
                throw new JobManagerException(35);
            }
            jobReq.setHostCount(tmpInt);
            tmpInt = this.getAsInt(rsl.getSingle("maxWallTime"), 0, 102);
            if (tmpInt < 0) {
                throw new JobManagerException(102);
            }
            jobReq.setMaxWallTime(tmpInt);
            tmpInt = this.getAsInt(rsl.getSingle("maxCpuTime"), 0, 104);
            if (tmpInt < 0) {
                throw new JobManagerException(104);
            }
            jobReq.setMaxCpuTime(tmpInt);
            tmpInt = this.getAsInt(rsl.getSingle("maxTime"), 0, 13);
            if (tmpInt < 0) {
                throw new JobManagerException(13);
            }
            jobReq.setMaxTime(tmpInt);
            tmpArg = rsl.getSingle("jobType");
            if (tmpArg != null) {
                if (tmpArg.equalsIgnoreCase("mpi")) {
                    tmpInt = 2;
                } else if (tmpArg.equalsIgnoreCase("single")) {
                    tmpInt = 0;
                } else if (tmpArg.equalsIgnoreCase("multiple")) {
                    tmpInt = 1;
                } else {
                    if (!tmpArg.equalsIgnoreCase("condor")) throw new JobManagerException(19);
                    tmpInt = 3;
                }
            } else {
                tmpInt = 1;
            }
            jobReq.setJobType(tmpInt);
            tmpArg = rsl.getSingle("dryrun");
            if (tmpArg != null && tmpArg.equalsIgnoreCase("yes")) {
                jobReq.setDryRun(true);
            } else {
                jobReq.setDryRun(false);
            }
            String inputFile = rsl.getSingle("stdin");
            if (inputFile != null) {
                inputFile = inputFile.indexOf("://") != -1 ? this.stageStdin(inputFile) : this.getPath(inputFile, dir);
            }
            jobReq.setStdin(inputFile);
            String outFile = this.getFile(rsl.getSingle("stdout"), dir, 73);
            jobReq.setStdout(outFile);
            String errFile = this.getFile(rsl.getSingle("stderr"), dir, 74);
            jobReq.setStderr(errFile);
            this.saveDelegatedCredentials();
            this.request(jobReq);
            return;
        }
        catch (JobManagerException e) {
            this._jobLogger.error((Object)"Job request failed.", (Throwable)((Object)e));
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this._jobLogger.error((Object)"Unexpected error.", (Throwable)e);
            this.dispose();
            throw new JobManagerException(27, (Throwable)e);
        }
    }

    private static boolean isAbsolutePath(String path) {
        int length = path.length();
        return length > 1 && path.charAt(0) == '/' || length > 2 && path.charAt(1) == ':' && Character.isLetter(path.charAt(0));
    }

    public abstract void request(JobRequest var1) throws JobManagerException;

    private int getAsInt(String tmpArg, int defValue, int errorCode) throws JobManagerException {
        if (tmpArg != null) {
            try {
                return Integer.parseInt(tmpArg);
            }
            catch (NumberFormatException e) {
                throw new JobManagerException(errorCode, (Throwable)e);
            }
        }
        return defValue;
    }

    private long getAsLong(String tmpArg, long defValue, int errorCode) throws JobManagerException {
        if (tmpArg != null) {
            try {
                return Long.parseLong(tmpArg);
            }
            catch (NumberFormatException e) {
                throw new JobManagerException(errorCode, (Throwable)e);
            }
        }
        return defValue;
    }

    private String getFile(String file, File dir, int err) throws JobManagerException {
        if (file == null) {
            return null;
        }
        if (file.indexOf("://") != -1) {
            if (this.allowStdioUrls) {
                return file;
            }
            return this.redirectThruFile(file, err);
        }
        return this.getPath(file, dir);
    }

    protected String redirectThruFile(String file, int err) throws JobManagerException {
        File outFile;
        OutputStream out = this.openUrl(file, err);
        try {
            outFile = File.createTempFile("output", ".tmp");
        }
        catch (IOException e) {
            throw new JobManagerException(err, (Throwable)e);
        }
        this.fileList.add(outFile);
        if (this._outputFollower == null) {
            this._outputFollower = new Tail();
            this._outputFollower.setLogger((Log)new Log4JLogger(this._jobLogger));
            this._outputFollower.start();
        }
        try {
            this._outputFollower.addFile(outFile, out, 0);
        }
        catch (IOException e) {
            this._jobLogger.error((Object)"Unexpected error in io redirection", (Throwable)e);
        }
        return outFile.getAbsolutePath();
    }

    protected OutputStream openUrl(String file, int err) throws JobManagerException {
        GlobusURL url = null;
        try {
            url = new GlobusURL(file);
        }
        catch (Exception e) {
            throw new JobManagerException(err, "Invalid url: " + file, e);
        }
        try {
            return this.openUrl(url);
        }
        catch (Exception e) {
            throw new JobManagerException(err, "Failed to open (remote): " + file, e);
        }
    }

    protected String getPath(String localFile, File dir) {
        if (localFile.length() == 0) {
            return localFile;
        }
        if (AbstractJobManager.isAbsolutePath(localFile)) {
            return localFile;
        }
        return new File(dir, localFile).getAbsolutePath();
    }

    protected OutputStream openUrl(GlobusURL url) throws Exception {
        String protocol = url.getProtocol();
        if (protocol.equalsIgnoreCase("https")) {
            return new GassOutputStream(this._credential, (Authorization)SelfAuthorization.getInstance(), url.getHost(), url.getPort(), url.getPath(), -1L, this.appendStdout);
        }
        if (protocol.equalsIgnoreCase("http")) {
            return new HTTPOutputStream(url.getHost(), url.getPort(), url.getPath(), -1L, this.appendStdout);
        }
        if (protocol.equalsIgnoreCase("gsiftp") || protocol.equalsIgnoreCase("gridftp")) {
            return new GridFTPOutputStream(this._credential, (Authorization)HostAuthorization.getInstance(), url.getHost(), url.getPort(), url.getPath(), this.appendStdout, true);
        }
        if (protocol.equalsIgnoreCase("ftp")) {
            return new FTPOutputStream(url.getHost(), url.getPort(), url.getUser(), url.getPwd(), url.getPath(), this.appendStdout);
        }
        throw new Exception("Protocol not supported: " + protocol);
    }

    public void signal(int signal, String args) throws JobManagerException {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("signal called: " + signal + " " + args));
        }
        switch (signal) {
            case 1: {
                this.cancel();
                break;
            }
            default: {
                throw new JobManagerException(108);
            }
        }
    }

    public void addJobStatusListener(JobStatusListener jobStatusListener) {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("addStatusListener: " + jobStatusListener));
        }
        if (jobStatusListener == null) {
            throw new IllegalArgumentException("job status listener cannot be null");
        }
        if (jobStatusListener instanceof JobDoneListener) {
            this._jobDoneListener = (JobDoneListener)jobStatusListener;
        } else {
            this._callbackUrl.put(jobStatusListener.getID(), jobStatusListener);
        }
    }

    public void removeJobStatusListener(JobStatusListener jobStatusListener) throws JobManagerException {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("removeStatusListener: " + jobStatusListener));
        }
        if (jobStatusListener == null) {
            throw new IllegalArgumentException("job status listener cannot be null");
        }
        this.removeJobStatusListenerByID(jobStatusListener.getID());
    }

    public void removeJobStatusListenerByID(String jobStatusListenerID) throws JobManagerException {
        if (this._jobLogger.isInfoEnabled()) {
            this._jobLogger.info((Object)("removeStatusListenerID: " + jobStatusListenerID));
        }
        if (jobStatusListenerID == null) {
            throw new IllegalArgumentException("job status listener id cannot be null");
        }
        JobStatusListener list = (JobStatusListener)this._callbackUrl.remove(jobStatusListenerID);
        if (list == null) {
            throw new JobManagerException(78);
        }
        list.dispose();
    }

    public int getStatus() {
        return this._status;
    }

    public int getFailureCode() {
        return this._failureCode;
    }

    public synchronized void setStatus(int status) {
        if (this._status == status) {
            return;
        }
        if (this.isValidStatus(status)) {
            this._status = status;
            if (this._jobLogger.isInfoEnabled()) {
                this._jobLogger.info((Object)("Setting job status to: " + this._status));
            }
            if (status == 8 || status == 4) {
                if (this._outputFollower != null) {
                    this._outputFollower.stop();
                    try {
                        this._outputFollower.join();
                    }
                    catch (Exception e) {
                        this._jobLogger.error((Object)"Unexpected error", (Throwable)e);
                    }
                }
                this.fireStatusUpdate();
                this.dispose();
            } else {
                this.fireStatusUpdate();
            }
        }
    }

    public void fireStatusUpdate() {
        Enumeration e = this._callbackUrl.elements();
        while (e.hasMoreElements()) {
            JobStatusListener listener = (JobStatusListener)e.nextElement();
            listener.statusChanged(this);
        }
    }

    protected void dispose() {
        this._jobLogger.info((Object)"[base jm] Cleaning up...");
        Iterator iter = this.fileList.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            if (this._jobLogger.isDebugEnabled()) {
                this._jobLogger.debug((Object)("Deleting tmp file: " + f));
            }
            f.delete();
        }
        if (this._callbackUrl != null) {
            Enumeration e = this._callbackUrl.elements();
            while (e.hasMoreElements()) {
                JobStatusListener listener = (JobStatusListener)e.nextElement();
                listener.dispose();
            }
        }
        if (this._jobDoneListener != null) {
            this._jobDoneListener.dispose();
        }
        if (this._outputFollower != null) {
            this._outputFollower.stop();
        }
    }

    private boolean isValidStatus(int status) {
        return status == 2 || status == 8 || status == 4 || status == 1 || status == 16;
    }

    public String stageExecutable(String url) throws JobManagerException {
        String file = null;
        try {
            file = this.stageFile(url);
        }
        catch (Exception e) {
            throw new JobManagerException(43, (Throwable)e);
        }
        Util.setFilePermissions((String)file, (int)700);
        return file;
    }

    public String stageStdin(String url) throws JobManagerException {
        try {
            return this.stageFile(url);
        }
        catch (Exception e) {
            throw new JobManagerException(44, (Throwable)e);
        }
    }

    private String getExtension(GlobusURL url) {
        char ch;
        String file = url.getPath();
        for (int i = file.length() - 1; i > 0 && (ch = file.charAt(i)) != '/' && ch != '\\'; --i) {
            if (ch != '.') continue;
            return file.substring(i);
        }
        return ".tmp";
    }

    protected String stageFile(String url) throws MalformedURLException, IOException, UrlCopyException {
        GlobusURL remoteUrl = new GlobusURL(url);
        File localFile = null;
        localFile = File.createTempFile("staged", this.getExtension(remoteUrl));
        this.fileList.add(localFile);
        GlobusURL localUrl = new GlobusURL(localFile.toURL());
        UrlCopy c = new UrlCopy();
        c.setCredentials(this._credential);
        c.setSourceUrl(remoteUrl);
        c.setDestinationUrl(localUrl);
        c.copy();
        return localFile.getAbsolutePath();
    }
}

