/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper.internal;

import java.io.IOException;
import java.io.InputStream;
import org.globus.gatekeeper.AuthorizationException;
import org.globus.gatekeeper.BadRequestException;
import org.globus.gatekeeper.GateKeeperException;
import org.globus.gatekeeper.ServiceNotFoundException;
import org.globus.gatekeeper.internal.GateKeeperRequest;
import org.globus.util.http.HTTPProtocol;

public class GateKeeperProtocol
extends HTTPProtocol {
    private static GateKeeperProtocol protocol = null;
    private static final String GATEKEEPER_APP = "application/x-globus-gram";

    public static GateKeeperProtocol getInstance(String prot) {
        if (protocol == null) {
            protocol = new GateKeeperProtocol();
        }
        return protocol;
    }

    public String getErrorMessage(Exception e) {
        if (e instanceof BadRequestException) {
            return GateKeeperProtocol.getBadRequestErrorReply();
        }
        if (e instanceof ServiceNotFoundException) {
            return GateKeeperProtocol.getFileNotFoundErrorReply();
        }
        if (e instanceof AuthorizationException) {
            return GateKeeperProtocol.getForbiddenErrorReply();
        }
        return GateKeeperProtocol.getServerErrorReply();
    }

    public String getPingSuccessMessage() {
        return GateKeeperProtocol.getOKReply((String)GATEKEEPER_APP);
    }

    public GateKeeperRequest parseRequest(InputStream in) throws IOException, GateKeeperException {
        return new GateKeeperRequest(in);
    }
}

