/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gatekeeper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.globus.gatekeeper.AuthorizationException;
import org.globus.gatekeeper.BadRequestException;
import org.globus.gatekeeper.GateKeeperException;
import org.globus.gatekeeper.GateKeeperServer;
import org.globus.gatekeeper.Service;
import org.globus.gatekeeper.ServiceException;
import org.globus.gatekeeper.internal.GateKeeperProtocol;
import org.globus.gatekeeper.internal.GateKeeperRequest;
import org.globus.gsi.gssapi.net.GssSocket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;

public class GateKeeperClient
extends Thread {
    private GateKeeperServer _service = null;
    private InputStream _is = null;
    private OutputStream _os = null;
    private Socket _s = null;
    private GateKeeperProtocol _gatekeeperProtocol = null;
    private Logger _logger;

    public GateKeeperClient(GateKeeperServer service, Socket s) {
        this._s = s;
        this._service = service;
        this._gatekeeperProtocol = GateKeeperProtocol.getInstance("GRAM1.0");
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            try {
                GateKeeperRequest req;
                boolean ping;
                this._is = this._s.getInputStream();
                this._os = this._s.getOutputStream();
                GssSocket socket = (GssSocket)this._s;
                GSSContext context = socket.getContext();
                String globusID = ((Object)context.getSrcName()).toString();
                if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("Authenticated globus user: " + globusID));
                }
                this._service.getGridMap().refresh();
                String userID = this._service.getGridMap().getUserID(globusID);
                if (userID == null) {
                    throw new AuthorizationException();
                }
                if (this._logger.isInfoEnabled()) {
                    this._logger.info((Object)("Authorized as local user: " + userID));
                }
                GSSCredential creds = context.getDelegCred();
                if (this._logger.isInfoEnabled()) {
                    if (creds == null) {
                        this._logger.info((Object)"Delegation not performed.");
                    } else {
                        this._logger.info((Object)"Delegation performed.");
                    }
                }
                if (ping = (req = this._gatekeeperProtocol.parseRequest(this._is)).isPing()) {
                    this.handlePing(creds, req);
                    break block17;
                }
                if (creds != null && !ping) {
                    this.handleRequest(creds, req);
                    break block17;
                }
                throw new BadRequestException();
            }
            catch (GateKeeperException e) {
                this._logger.error((Object)"Client request failed.", (Throwable)e);
                this.write(this._gatekeeperProtocol.getErrorMessage(e));
            }
            catch (IOException e) {
                this._logger.error((Object)"IOError", (Throwable)e);
            }
            catch (Exception e) {
                this._logger.error((Object)"Unexpected error.", (Throwable)e);
                this.write(this._gatekeeperProtocol.getErrorMessage(e));
            }
            finally {
                this.close();
            }
        }
    }

    private void write(String msg) {
        if (msg == null) {
            return;
        }
        try {
            this._os.write(msg.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void close() {
        if (this._os != null) {
            try {
                this._os.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._is != null) {
            try {
                this._is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this._s != null) {
            try {
                this._s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Client disconnected: " + this._s.getInetAddress() + ":" + this._s.getPort()));
        }
    }

    protected void handlePing(GSSCredential creds, GateKeeperRequest cr) throws GateKeeperException {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Ping request for: " + cr.getService()));
        }
        Service service = this._service.getService(cr.getService());
        this.write(this._gatekeeperProtocol.getPingSuccessMessage());
        this._logger.info((Object)"Ping successfull.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(GSSCredential creds, GateKeeperRequest cr) throws GateKeeperException {
        if (this._logger.isInfoEnabled()) {
            this._logger.info((Object)("Service requested: " + cr.getService()));
        }
        Service service = this._service.getService(cr.getService());
        service.setCredentials(creds);
        String msg = null;
        try {
            service.request(cr);
            msg = service.getRequestSuccessMessage();
            this._logger.info((Object)("Service request successfull: " + service.getHandle()));
            this.write(msg);
        }
        catch (ServiceException e) {
            try {
                msg = service.getRequestFailMessage((Exception)((Object)e));
                this._logger.info((Object)"Service request failed.", (Throwable)((Object)e));
                this.write(msg);
            }
            catch (Throwable throwable) {
                this.write(msg);
                throw throwable;
            }
        }
    }
}

