#ifndef SIMPLEPRODUCER_HH
#define SIMPLEPRODUCER_HH

/* SimpleProducer
 * A simple, encapsulated message producer
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 *
 * Originally taken from HelloWorldProducer in the ActiveMQcpp
 * examples. The original license follows:
 *
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/library/ActiveMQCPP.h>
#include <activemq/core/ActiveMQConnectionFactory.h>

#include <string>
#include <iostream>

using namespace activemq::core;
using namespace cms;
using namespace std;

class SimpleProducer {

private:




protected:

   Connection* connection;
   Session* session;
   Destination* destination;
   MessageProducer* producer;
   bool useTopic;
   bool sessionTransacted;
   std::string brokerURI, destname;

   void cleanup();
public:

    SimpleProducer( const std::string& brokerURI,
                    const std::string& destname, // The name of the queue or topic
                    bool useTopic = false,
                    bool sessionTransacted = false );

    virtual ~SimpleProducer() {
        cleanup();
    }

   // yeah it does what it says
   virtual int Connect();

   // Sends the appropriate message in order to say hello
   virtual int Say(char *text, int count);




};


#endif
