#ifndef SIMPLECONSUMER_HH
#define SIMPLECONSUMER_HH

/* SimpleConsumer
 * A simple, encapsulated message consumer
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 *
 * Originally taken from HelloWorldConsumer in the ActiveMQcpp
 * examples. The original license follows:
 *
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include <activemq/library/ActiveMQCPP.h>
#include <activemq/core/ActiveMQConnectionFactory.h>
#include <cms/ExceptionListener.h>
#include <cms/MessageListener.h>

#include <string>
#include <iostream>
#include <stdlib.h>

class SimpleConsumer : public cms::ExceptionListener,
                       public cms::MessageListener {

protected:

   cms::Connection* connection;
   cms::Session* session;
   cms::Destination* destination;
   cms::MessageConsumer* consumer;
   bool useTopic;
   bool sessionTransacted;
   std::string brokerURI;
   std::string destname;

   // Sends the pending acks back
   int CommitMessages();
public:

   SimpleConsumer( const std::string& brokerURI,
                   const std::string& destname, // The name of the topic or queue
                   bool useTopic = false,
                   bool sessionTransacted = false ) {
      this->connection = NULL;
      this->session = NULL;
      this->destination = NULL;
      this->consumer = NULL;

      this->destname = destname;
      this->useTopic = useTopic;
      this->sessionTransacted = sessionTransacted;
      this->brokerURI = brokerURI;

   }

   virtual ~SimpleConsumer() throw() {
      cleanup();
   }

   // Try to connect to the broker. Returns != 0 if this is not possible.
   int Connect();

   // Called from the consumer since this class is a registered MessageListener.
   virtual void onMessage( const cms::Message* message ) throw();

   // If something bad happens you see it here as this class is also been
   // registered as an ExceptionListener with the connection.
   virtual void onException( const cms::CMSException& ex AMQCPP_UNUSED) throw();

private:
   void cleanup();
};


#endif
