#ifndef SEMSGPRODUCER_HH
#define SEMSGPRODUCER_HH

/* SEMsgProducer
 * The main API that produces the Catalogue Synchronization messages
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 */

#include "RunnableProducer.hh"
#include "SEMsgSecurity.hh"
#include "Config.hh"
#include "SimpleDebug.hh"

class SEMsgProducer : public RunnableProducer {
private:
  std::string authDN;
  std::string voname;
  std::vector<std::string> fqans;

protected:
   SEMsgSecurity sec;

   // Set the basic properties of the msg
   // e.g. protocol version and primitive name
   int InitMsgProperties(cms::Message *msg, char *command);

   
public:
  SEMsgProducer( SimpleDebug *logobj,
		 Config *cfgobj,
		 const std::string& brokerURI,
		 const std::string& destname,
		 bool useTopic = false,
		 bool sessionTransacted = false ):
    RunnableProducer(brokerURI, destname, useTopic, sessionTransacted) {

    Config::Set(cfgobj);
    SimpleDebug::Set(logobj);
    sec.Init("prodapi");
    
   };



   // Fill the private security fields with the security-related parameters
   void SetSecFields(char *authDN,	
		      char *voname,
		      char **fqans,
		      int fqanscnt);
   void ResetSecFields();

   // The useful messages to send
   virtual int NotifyNotAvailable(char *authDN, char *filename);

   virtual int NotifyAvailable(char *authDN, char *filename);
   virtual int NotifyChmod(char *authDN, char *filename, int perm);
   virtual int NotifyChown(char *authDN, char *filename, char *username, char *groupname);
   virtual int NotifyDeleted(char *authDN, char *filename);
   virtual int NotifySetACL(char *authDN, char *filename, char *acl);
   virtual int NotifyAddReplica(char *authDN,
				char      *lfn,
				char      *guid,
				int        mode,
				long long  size,
				char      *csumtype,
				char      *csumvalue,
				char      *server,
				char      *sfn,
				char      *status,
				char      *f_type,
				char      *poolname,
				char      *fs);


   // Return non-0 if the corresponding message would be sent if requested to
   virtual int CanNotifyNotAvailable();
   virtual int CanNotifyAvailable();
   virtual int CanNotifyChmod();
   virtual int CanNotifyChown();
   virtual int CanNotifyDeleted();
   virtual int CanNotifySetACL();
   virtual int CanNotifyAddReplica();


  virtual int SignMessage( cms::MapMessage* m ) {
    return sec.SignMessage(m);
  };

// Check the signature of the message
  virtual int CheckMessage( const cms::MapMessage* m ) {
    return sec.CheckMessage(m);
  };

};





// ------------------------------------------------------------------------------------
// Plugin-related stuff
// ------------------------------------------------------------------------------------

#define GetSEMsgProducerArgs \
    SimpleDebug *logobj,	                           \
    Config *cfgobj,					   \
    const std::string& brokerURI,			   \
    const std::string& destname,			   \
    bool useTopic,					   \
    bool sessionTransacted        

// The plugin functionality. This function invokes the plugin loader, looking for the
// plugin where to call the hook function
SEMsgProducer *GetSEMsgProducerPluginClass(char *pluginPath, GetSEMsgProducerArgs);




// The plugin functionality. This function is invoked by the plugin loader, and
// returns an instance of the class.
extern "C" SEMsgProducer *GetSEMsgProducer(GetSEMsgProducerArgs);



#endif
