#ifndef SEMSGCONSUMER_HH
#define SEMSGCONSUMER_HH

/* SEMsgConsumer
 * Base class for plugins that feed external systems with
 * app-level notifications.
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 */

#include "RunnableConsumer.hh"

#include "SEMsgProtoDefs.hh"
#include "SimpleDebug.hh"
#include "SEMsgSecurity.hh"
#include "Config.hh"


// Wrapper class that dispatches the messages to the various callbacks
class SEMsgConsumer: public RunnableConsumer {
protected:
  SEMsgSecurity sec;
public:
   SEMsgConsumer( const std::string& brokerURI,
                  const std::string& destname,
                  bool useTopic = false,
                  bool sessionTransacted = false ):
      RunnableConsumer(brokerURI, destname, useTopic, sessionTransacted) {


     sec.Init((char *)"consd");


   };
 
   virtual ~SEMsgConsumer() throw() {};

   // To know if the security was correctly initialized
   bool GetSecurityStatus() {
     return sec.GetSecStatus();
   }

   // Check the signature of the message
   virtual int CheckMessage( const cms::MapMessage* m ) {
     return sec.CheckMessage(m);
   };

   void DumpMessage( const cms::MapMessage* m );

   // Override the onMessage method and dispatch to the various callbacks, if defined
   virtual void onMessage( const cms::Message* m ) throw();
   
   // And here are the various events.
   // Proper subclasses of this class are supposed to do the real work
   virtual void onMessageChmod( const cms::MapMessage* m ) {
      Error("SEMsgConsumer::onMessageChmod", "Invoked empty function.");
      return;
   }

   virtual void onMessageFileNotAvailable( const cms::MapMessage* m ) {
      Error("SEMsgConsumer::onMessageFileNotAvailable", "Invoked empty function.");
      return;
  }

  virtual void onMessageFileAvailable( const cms::MapMessage* m ) {
      Error("SEMsgConsumer::onMessageFileAvailable", "Invoked empty function.");
      return;
  }

  virtual void onMessageAddReplica( const cms::MapMessage* m ) {
    Error("SEMsgConsumer::onMessageAddReplica", "Invoked empty function.");
      return;
  }

  virtual void onMessageFileDeleted( const cms::MapMessage* m ) {
    Error("SEMsgConsumer::onMessageFileDeleted", "Invoked empty function.");
      return;
  }

  virtual void onMessageSetACL( const cms::MapMessage* m ) {
    Error("SEMsgConsumer::onMessageSetACL", "Invoked empty function.");
      return;
  }


  // ------------------------------------
  // Utility function, to retrieve the voms auth stuff from a string buffer. Up to 10 fqans are supported
  // ------------------------------------
  static void unpackAuthstuff(char *inbuf, char *DN, char *voname, char ***fqans, int *nfqans);
  static void freeFqans(char **fqans, int nfqans);

protected:
  // Gets a string field from a message, returns the length of the field or -1 if not found
  // If counter < 0 then it does not look for a numbered field
  int getStringField(std::string &val,
		     const cms::MapMessage* m,
		     const char *fieldname,
		     int counter,
		     const char *errordesc);

  
  // Gets an int field from a message, returns > 0 if found, or -1 if not found
  // If counter < 0 then it does not look for a numbered field
  int getLongField(long &val,
		  const cms::MapMessage* m,
		  const char *fieldname,
		  int counter,
		  const char *errordesc);

  // Gets a long long field from a message, returns > 0 if found, or -1 if not found
  // If counter < 0 then it does not look for a numbered field
  int getLongLongField(long long &val,
		       const cms::MapMessage* m,
		       const char *fieldname,
		       int counter,
		       const char *errordesc);
  };




// ------------------------------------------------------------------------------------
// Plugin-related stuff
// ------------------------------------------------------------------------------------

#define GetSEMsgConsumerArgs const std::string& brokerURI, \
                             const std::string& destname,  \
                             bool useTopic,                \
                             bool sessionTransacted        

// The plugin functionality. This function invokes the plugin loader, looking for the
// plugin where to call the hook function
SEMsgConsumer *GetSEMsgConsumerPluginClass(char *pluginPath, GetSEMsgConsumerArgs);




// The plugin functionality. This function is invoked by the plugin loader, and
// returns an instance of the class.
extern "C" SEMsgConsumer *GetSEMsgConsumer(GetSEMsgConsumerArgs);

#endif
