
#ifndef GLITE_LB_JOB_ATTRS2_H
#define GLITE_LB_JOB_ATTRS2_H

#define GLITE_JP_LB_NS "http://egee.cesnet.cz/en/Schema/LB/Attributes"
#define GLITE_JP_LB_JDL_NS "http://egee.cesnet.cz/en/Schema/LB/Attributes:JDL"

/** Job status */
#define GLITE_JP_LB_status	GLITE_JP_LB_NS ":status"
/** Id of the job */
#define GLITE_JP_LB_jobId	GLITE_JP_LB_NS ":jobId"
/** Job owner */
#define GLITE_JP_LB_owner	GLITE_JP_LB_NS ":owner"
/** Type of job */
#define GLITE_JP_LB_jobtype	GLITE_JP_LB_NS ":jobtype"
/** parent job of subjob */
#define GLITE_JP_LB_parentJob	GLITE_JP_LB_NS ":parentJob"
/** string used for generation of subjob IDs */
#define GLITE_JP_LB_seed	GLITE_JP_LB_NS ":seed"
/** number of subjobs */
#define GLITE_JP_LB_childrenNum	GLITE_JP_LB_NS ":childrenNum"
/** list of subjob IDs */
#define GLITE_JP_LB_children	GLITE_JP_LB_NS ":children"
/** summary (histogram) of children job states */
#define GLITE_JP_LB_childrenHist	GLITE_JP_LB_NS ":childrenHist"
/** full status information of the children */
#define GLITE_JP_LB_childrenStates	GLITE_JP_LB_NS ":childrenStates"
/** Id within Condor-G */
#define GLITE_JP_LB_condorId	GLITE_JP_LB_NS ":condorId"
/** Globus allocated Id */
#define GLITE_JP_LB_globusId	GLITE_JP_LB_NS ":globusId"
/** Id within LRMS */
#define GLITE_JP_LB_localId	GLITE_JP_LB_NS ":localId"
/** User submitted job description */
#define GLITE_JP_LB_jdl	GLITE_JP_LB_NS ":jdl"
/** Full job description after matchmaking */
#define GLITE_JP_LB_matchedJdl	GLITE_JP_LB_NS ":matchedJdl"
/** ID of CE where the job is being sent */
#define GLITE_JP_LB_destination	GLITE_JP_LB_NS ":destination"
/** ClassAd passed to Condor-G for last job execution */
#define GLITE_JP_LB_condorJdl	GLITE_JP_LB_NS ":condorJdl"
/** Job RSL sent to Globus */
#define GLITE_JP_LB_rsl	GLITE_JP_LB_NS ":rsl"
/** Reason of being in this status, if any */
#define GLITE_JP_LB_reason	GLITE_JP_LB_NS ":reason"
/** Where the job is being processed */
#define GLITE_JP_LB_location	GLITE_JP_LB_NS ":location"
/** Worker node where the job is executed */
#define GLITE_JP_LB_ceNode	GLITE_JP_LB_NS ":ceNode"
/** Network server handling the job */
#define GLITE_JP_LB_networkServer	GLITE_JP_LB_NS ":networkServer"
/** Subjob failed (the parent job will fail too) */
#define GLITE_JP_LB_subjobFailed	GLITE_JP_LB_NS ":subjobFailed"
/** Return code */
#define GLITE_JP_LB_doneCode	GLITE_JP_LB_NS ":doneCode"
/** Unix exit code */
#define GLITE_JP_LB_exitCode	GLITE_JP_LB_NS ":exitCode"
/** The job was resubmitted */
#define GLITE_JP_LB_resubmitted	GLITE_JP_LB_NS ":resubmitted"
/** Cancellation request in progress */
#define GLITE_JP_LB_cancelling	GLITE_JP_LB_NS ":cancelling"
/** Reason of cancel */
#define GLITE_JP_LB_cancelReason	GLITE_JP_LB_NS ":cancelReason"
/** Consumed CPU time */
#define GLITE_JP_LB_cpuTime	GLITE_JP_LB_NS ":cpuTime"
/** List of pairs (user_tag, user_value) */
#define GLITE_JP_LB_userTags	GLITE_JP_LB_NS ":userTags"
/** When entered this status */
#define GLITE_JP_LB_stateEnterTime	GLITE_JP_LB_NS ":stateEnterTime"
/** Last known event of the job */
#define GLITE_JP_LB_lastUpdateTime	GLITE_JP_LB_NS ":lastUpdateTime"
/** When all previous states were entered */
#define GLITE_JP_LB_stateEnterTimes	GLITE_JP_LB_NS ":stateEnterTimes"
/** Some logged information has not arrived yet */
#define GLITE_JP_LB_expectUpdate	GLITE_JP_LB_NS ":expectUpdate"
/** Sources of the missing information */
#define GLITE_JP_LB_expectFrom	GLITE_JP_LB_NS ":expectFrom"
/** ACL of the job */
#define GLITE_JP_LB_acl	GLITE_JP_LB_NS ":acl"
/** User payload started */
#define GLITE_JP_LB_payloadRunning	GLITE_JP_LB_NS ":payloadRunning"
/** Possible job destinations */
#define GLITE_JP_LB_possibleDestinations	GLITE_JP_LB_NS ":possibleDestinations"
/** CE nodes matching to possible_destinations */
#define GLITE_JP_LB_possibleCeNodes	GLITE_JP_LB_NS ":possibleCeNodes"
/** Job is suspended */
#define GLITE_JP_LB_suspended	GLITE_JP_LB_NS ":suspended"
/** Reason for the suspend */
#define GLITE_JP_LB_suspendReason	GLITE_JP_LB_NS ":suspendReason"
/** Concatenated job failure reasons, possibly from deeper middleware layers */
#define GLITE_JP_LB_failureReasons	GLITE_JP_LB_NS ":failureReasons"
/** Job reached final status and may be removed from proxy */
#define GLITE_JP_LB_removeFromProxy	GLITE_JP_LB_NS ":removeFromProxy"
/** Hostname or address of UI used to submit the job */
#define GLITE_JP_LB_uiHost	GLITE_JP_LB_NS ":uiHost"
/** FQAN used to register the job */
#define GLITE_JP_LB_userFqans	GLITE_JP_LB_NS ":userFqans"
/** Flag is set on incomming Clear event */
#define GLITE_JP_LB_sandboxRetrieved	GLITE_JP_LB_NS ":sandboxRetrieved"
/** Status of Job wrapper */
#define GLITE_JP_LB_jwStatus	GLITE_JP_LB_NS ":jwStatus"
/** Unparsed JDL classad */
#define GLITE_JP_LB_jdlClassad	GLITE_JP_LB_NS ":jdlClassad"
/** Input sandbox corresponding to the job */
#define GLITE_JP_LB_isbTransfer	GLITE_JP_LB_NS ":isbTransfer"
/** Output sandbox corresponding to the job */
#define GLITE_JP_LB_osbTransfer	GLITE_JP_LB_NS ":osbTransfer"
/** Owner of the actual job payload (e.g., for pilot jobs) */
#define GLITE_JP_LB_payloadOwner	GLITE_JP_LB_NS ":payloadOwner"
/** List of access rights (human readable variant of acl) */
#define GLITE_JP_LB_accessRights	GLITE_JP_LB_NS ":accessRights"
/** Job history. */
#define GLITE_JP_LB_history	GLITE_JP_LB_NS ":history"
/** Job state which would probably return PBS qstat (Q/R/C/....) */
#define GLITE_JP_LB_pbsState	GLITE_JP_LB_NS ":pbsState"
/** Job substate */
#define GLITE_JP_LB_pbsSubstate	GLITE_JP_LB_NS ":pbsSubstate"
/** Name of queue in which is job queued */
#define GLITE_JP_LB_pbsQueue	GLITE_JP_LB_NS ":pbsQueue"
/** Owner of job */
#define GLITE_JP_LB_pbsOwner	GLITE_JP_LB_NS ":pbsOwner"
/** Name of job */
#define GLITE_JP_LB_pbsName	GLITE_JP_LB_NS ":pbsName"
/** Glued reasons/errors leading to pending events */
#define GLITE_JP_LB_pbsReason	GLITE_JP_LB_NS ":pbsReason"
/** Name of pbs scheduler */
#define GLITE_JP_LB_pbsScheduler	GLITE_JP_LB_NS ":pbsScheduler"
/** Hostname of node where job is running */
#define GLITE_JP_LB_pbsDestHost	GLITE_JP_LB_NS ":pbsDestHost"
/** PID of running job */
#define GLITE_JP_LB_pbsPid	GLITE_JP_LB_NS ":pbsPid"
/** Resources requested */
#define GLITE_JP_LB_pbsResourceRequested	GLITE_JP_LB_NS ":pbsResourceRequested"
/** Resource usage */
#define GLITE_JP_LB_pbsResourceUsage	GLITE_JP_LB_NS ":pbsResourceUsage"
/** Job exit status */
#define GLITE_JP_LB_pbsExitStatus	GLITE_JP_LB_NS ":pbsExitStatus"
/** Glued error descriptions from error events */
#define GLITE_JP_LB_pbsErrorDesc	GLITE_JP_LB_NS ":pbsErrorDesc"
/** Condor job status  */
#define GLITE_JP_LB_condorStatus	GLITE_JP_LB_NS ":condorStatus"
/** Condor job Universe (in job ClassAds) */
#define GLITE_JP_LB_condorUniverse	GLITE_JP_LB_NS ":condorUniverse"
/** Job owner */
#define GLITE_JP_LB_condorOwner	GLITE_JP_LB_NS ":condorOwner"
/** Job preempting */
#define GLITE_JP_LB_condorPreempting	GLITE_JP_LB_NS ":condorPreempting"
/** PID of Shadow */
#define GLITE_JP_LB_condorShadowPid	GLITE_JP_LB_NS ":condorShadowPid"
/** Condor shadow exit status (see h/exit.h) */
#define GLITE_JP_LB_condorShadowExitStatus	GLITE_JP_LB_NS ":condorShadowExitStatus"
/** PID of Starter */
#define GLITE_JP_LB_condorStarterPid	GLITE_JP_LB_NS ":condorStarterPid"
/** Condor starter exit status */
#define GLITE_JP_LB_condorStarterExitStatus	GLITE_JP_LB_NS ":condorStarterExitStatus"
/** PID of running job */
#define GLITE_JP_LB_condorJobPid	GLITE_JP_LB_NS ":condorJobPid"
/** Job exit status */
#define GLITE_JP_LB_condorJobExitStatus	GLITE_JP_LB_NS ":condorJobExitStatus"
/** Hostname of node where job is running */
#define GLITE_JP_LB_condorDestHost	GLITE_JP_LB_NS ":condorDestHost"
/** Glued reasons/errors leading to pending events */
#define GLITE_JP_LB_condorReason	GLITE_JP_LB_NS ":condorReason"
/** Glued error descriptions from error events */
#define GLITE_JP_LB_condorErrorDesc	GLITE_JP_LB_NS ":condorErrorDesc"
/** CREAM job state */
#define GLITE_JP_LB_creamState	GLITE_JP_LB_NS ":creamState"
/** CREAM local job id */
#define GLITE_JP_LB_creamId	GLITE_JP_LB_NS ":creamId"
/** Job owner */
#define GLITE_JP_LB_creamOwner	GLITE_JP_LB_NS ":creamOwner"
/** Address of the CREAM service */
#define GLITE_JP_LB_creamEndpoint	GLITE_JP_LB_NS ":creamEndpoint"
/** JDL passed to the CREAM */
#define GLITE_JP_LB_creamJdl	GLITE_JP_LB_NS ":creamJdl"
/** Reason of the state or command */
#define GLITE_JP_LB_creamReason	GLITE_JP_LB_NS ":creamReason"
/** Reason of any failure */
#define GLITE_JP_LB_creamFailureReason	GLITE_JP_LB_NS ":creamFailureReason"
/** LRMS local id */
#define GLITE_JP_LB_creamLrmsId	GLITE_JP_LB_NS ":creamLrmsId"
/** Worker node where the job is executed */
#define GLITE_JP_LB_creamNode	GLITE_JP_LB_NS ":creamNode"
/** Job done code, uses done_code enum */
#define GLITE_JP_LB_creamDoneCode	GLITE_JP_LB_NS ":creamDoneCode"
/** Job exit code */
#define GLITE_JP_LB_creamExitCode	GLITE_JP_LB_NS ":creamExitCode"
/** Cancellation request in process */
#define GLITE_JP_LB_creamCancelling	GLITE_JP_LB_NS ":creamCancelling"
/** Consumed CPU time */
#define GLITE_JP_LB_creamCpuTime	GLITE_JP_LB_NS ":creamCpuTime"
/** Users jw_status enum */
#define GLITE_JP_LB_creamJwStatus	GLITE_JP_LB_NS ":creamJwStatus"
/** Compute job corresponding to file transfer */
#define GLITE_JP_LB_ftComputeJob	GLITE_JP_LB_NS ":ftComputeJob"
/** Type of sandbox */
#define GLITE_JP_LB_ftSandboxType	GLITE_JP_LB_NS ":ftSandboxType"
/** File transfer source */
#define GLITE_JP_LB_ftSrc	GLITE_JP_LB_NS ":ftSrc"
/** File transfer destination */
#define GLITE_JP_LB_ftDest	GLITE_JP_LB_NS ":ftDest"
/** VM job state */
#define GLITE_JP_LB_vmState	GLITE_JP_LB_NS ":vmState"
/** VM image */
#define GLITE_JP_LB_vmImage	GLITE_JP_LB_NS ":vmImage"
/** VM requirement on physical machine */
#define GLITE_JP_LB_vmRequire	GLITE_JP_LB_NS ":vmRequire"
/** VM usage */
#define GLITE_JP_LB_vmUsage	GLITE_JP_LB_NS ":vmUsage"
/** VM hostname */
#define GLITE_JP_LB_vmHostname	GLITE_JP_LB_NS ":vmHostname"
/** physical machine on which VM runs */
#define GLITE_JP_LB_vmMachine	GLITE_JP_LB_NS ":vmMachine"
/** VM id */
#define GLITE_JP_LB_vmId	GLITE_JP_LB_NS ":vmId"
/** VM name */
#define GLITE_JP_LB_vmName	GLITE_JP_LB_NS ":vmName"
/** hostname of physical machine running VM */
#define GLITE_JP_LB_vmPhyHostname	GLITE_JP_LB_NS ":vmPhyHostname"
/** system is shooting down */
#define GLITE_JP_LB_vmSystemHalting	GLITE_JP_LB_NS ":vmSystemHalting"
/** name of the VM manager */
#define GLITE_JP_LB_vmManager	GLITE_JP_LB_NS ":vmManager"

#define GLITE_JP_LB_CLASSAD_NS "http://jdl"

#define ATTRS2_OFFSET	100

typedef enum _lb_attrs2 {
	attr2_UNDEF = ATTRS2_OFFSET,
	attr2_status, /** Job status */
	attr2_jobId, /** Id of the job */
	attr2_owner, /** Job owner */
	attr2_jobtype, /** Type of job */
	attr2_parentJob, /** parent job of subjob */
	attr2_seed, /** string used for generation of subjob IDs */
	attr2_childrenNum, /** number of subjobs */
	attr2_children, /** list of subjob IDs */
	attr2_childrenHist, /** summary (histogram) of children job states */
	attr2_childrenStates, /** full status information of the children */
	attr2_condorId, /** Id within Condor-G */
	attr2_globusId, /** Globus allocated Id */
	attr2_localId, /** Id within LRMS */
	attr2_jdl, /** User submitted job description */
	attr2_matchedJdl, /** Full job description after matchmaking */
	attr2_destination, /** ID of CE where the job is being sent */
	attr2_condorJdl, /** ClassAd passed to Condor-G for last job execution */
	attr2_rsl, /** Job RSL sent to Globus */
	attr2_reason, /** Reason of being in this status, if any */
	attr2_location, /** Where the job is being processed */
	attr2_ceNode, /** Worker node where the job is executed */
	attr2_networkServer, /** Network server handling the job */
	attr2_subjobFailed, /** Subjob failed (the parent job will fail too) */
	attr2_doneCode, /** Return code */
	attr2_exitCode, /** Unix exit code */
	attr2_resubmitted, /** The job was resubmitted */
	attr2_cancelling, /** Cancellation request in progress */
	attr2_cancelReason, /** Reason of cancel */
	attr2_cpuTime, /** Consumed CPU time */
	attr2_userTags, /** List of pairs (user_tag, user_value) */
	attr2_stateEnterTime, /** When entered this status */
	attr2_lastUpdateTime, /** Last known event of the job */
	attr2_stateEnterTimes, /** When all previous states were entered */
	attr2_expectUpdate, /** Some logged information has not arrived yet */
	attr2_expectFrom, /** Sources of the missing information */
	attr2_acl, /** ACL of the job */
	attr2_payloadRunning, /** User payload started */
	attr2_possibleDestinations, /** Possible job destinations */
	attr2_possibleCeNodes, /** CE nodes matching to possible_destinations */
	attr2_suspended, /** Job is suspended */
	attr2_suspendReason, /** Reason for the suspend */
	attr2_failureReasons, /** Concatenated job failure reasons, possibly from deeper middleware layers */
	attr2_removeFromProxy, /** Job reached final status and may be removed from proxy */
	attr2_uiHost, /** Hostname or address of UI used to submit the job */
	attr2_userFqans, /** FQAN used to register the job */
	attr2_sandboxRetrieved, /** Flag is set on incomming Clear event */
	attr2_jwStatus, /** Status of Job wrapper */
	attr2_jdlClassad, /** Unparsed JDL classad */
	attr2_isbTransfer, /** Input sandbox corresponding to the job */
	attr2_osbTransfer, /** Output sandbox corresponding to the job */
	attr2_payloadOwner, /** Owner of the actual job payload (e.g., for pilot jobs) */
	attr2_accessRights, /** List of access rights (human readable variant of acl) */
	attr2_history, /** Job history. */
	attr2_pbsState, /** Job state which would probably return PBS qstat (Q/R/C/....) */
	attr2_pbsSubstate, /** Job substate */
	attr2_pbsQueue, /** Name of queue in which is job queued */
	attr2_pbsOwner, /** Owner of job */
	attr2_pbsName, /** Name of job */
	attr2_pbsReason, /** Glued reasons/errors leading to pending events */
	attr2_pbsScheduler, /** Name of pbs scheduler */
	attr2_pbsDestHost, /** Hostname of node where job is running */
	attr2_pbsPid, /** PID of running job */
	attr2_pbsResourceRequested, /** Resources requested */
	attr2_pbsResourceUsage, /** Resource usage */
	attr2_pbsExitStatus, /** Job exit status */
	attr2_pbsErrorDesc, /** Glued error descriptions from error events */
	attr2_condorStatus, /** Condor job status  */
	attr2_condorUniverse, /** Condor job Universe (in job ClassAds) */
	attr2_condorOwner, /** Job owner */
	attr2_condorPreempting, /** Job preempting */
	attr2_condorShadowPid, /** PID of Shadow */
	attr2_condorShadowExitStatus, /** Condor shadow exit status (see h/exit.h) */
	attr2_condorStarterPid, /** PID of Starter */
	attr2_condorStarterExitStatus, /** Condor starter exit status */
	attr2_condorJobPid, /** PID of running job */
	attr2_condorJobExitStatus, /** Job exit status */
	attr2_condorDestHost, /** Hostname of node where job is running */
	attr2_condorReason, /** Glued reasons/errors leading to pending events */
	attr2_condorErrorDesc, /** Glued error descriptions from error events */
	attr2_creamState, /** CREAM job state */
	attr2_creamId, /** CREAM local job id */
	attr2_creamOwner, /** Job owner */
	attr2_creamEndpoint, /** Address of the CREAM service */
	attr2_creamJdl, /** JDL passed to the CREAM */
	attr2_creamReason, /** Reason of the state or command */
	attr2_creamFailureReason, /** Reason of any failure */
	attr2_creamLrmsId, /** LRMS local id */
	attr2_creamNode, /** Worker node where the job is executed */
	attr2_creamDoneCode, /** Job done code, uses done_code enum */
	attr2_creamExitCode, /** Job exit code */
	attr2_creamCancelling, /** Cancellation request in process */
	attr2_creamCpuTime, /** Consumed CPU time */
	attr2_creamJwStatus, /** Users jw_status enum */
	attr2_ftComputeJob, /** Compute job corresponding to file transfer */
	attr2_ftSandboxType, /** Type of sandbox */
	attr2_ftSrc, /** File transfer source */
	attr2_ftDest, /** File transfer destination */
	attr2_vmState, /** VM job state */
	attr2_vmImage, /** VM image */
	attr2_vmRequire, /** VM requirement on physical machine */
	attr2_vmUsage, /** VM usage */
	attr2_vmHostname, /** VM hostname */
	attr2_vmMachine, /** physical machine on which VM runs */
	attr2_vmId, /** VM id */
	attr2_vmName, /** VM name */
	attr2_vmPhyHostname, /** hostname of physical machine running VM */
	attr2_vmSystemHalting, /** system is shooting down */
	attr2_vmManager, /** name of the VM manager */
} lb_attrs2;

static const char *lb_attrNames2[] = {
	"UNDEFINED",
	GLITE_JP_LB_status,
	GLITE_JP_LB_jobId,
	GLITE_JP_LB_owner,
	GLITE_JP_LB_jobtype,
	GLITE_JP_LB_parentJob,
	GLITE_JP_LB_seed,
	GLITE_JP_LB_childrenNum,
	GLITE_JP_LB_children,
	GLITE_JP_LB_childrenHist,
	GLITE_JP_LB_childrenStates,
	GLITE_JP_LB_condorId,
	GLITE_JP_LB_globusId,
	GLITE_JP_LB_localId,
	GLITE_JP_LB_jdl,
	GLITE_JP_LB_matchedJdl,
	GLITE_JP_LB_destination,
	GLITE_JP_LB_condorJdl,
	GLITE_JP_LB_rsl,
	GLITE_JP_LB_reason,
	GLITE_JP_LB_location,
	GLITE_JP_LB_ceNode,
	GLITE_JP_LB_networkServer,
	GLITE_JP_LB_subjobFailed,
	GLITE_JP_LB_doneCode,
	GLITE_JP_LB_exitCode,
	GLITE_JP_LB_resubmitted,
	GLITE_JP_LB_cancelling,
	GLITE_JP_LB_cancelReason,
	GLITE_JP_LB_cpuTime,
	GLITE_JP_LB_userTags,
	GLITE_JP_LB_stateEnterTime,
	GLITE_JP_LB_lastUpdateTime,
	GLITE_JP_LB_stateEnterTimes,
	GLITE_JP_LB_expectUpdate,
	GLITE_JP_LB_expectFrom,
	GLITE_JP_LB_acl,
	GLITE_JP_LB_payloadRunning,
	GLITE_JP_LB_possibleDestinations,
	GLITE_JP_LB_possibleCeNodes,
	GLITE_JP_LB_suspended,
	GLITE_JP_LB_suspendReason,
	GLITE_JP_LB_failureReasons,
	GLITE_JP_LB_removeFromProxy,
	GLITE_JP_LB_uiHost,
	GLITE_JP_LB_userFqans,
	GLITE_JP_LB_sandboxRetrieved,
	GLITE_JP_LB_jwStatus,
	GLITE_JP_LB_jdlClassad,
	GLITE_JP_LB_isbTransfer,
	GLITE_JP_LB_osbTransfer,
	GLITE_JP_LB_payloadOwner,
	GLITE_JP_LB_accessRights,
	GLITE_JP_LB_history,
	GLITE_JP_LB_pbsState,
	GLITE_JP_LB_pbsSubstate,
	GLITE_JP_LB_pbsQueue,
	GLITE_JP_LB_pbsOwner,
	GLITE_JP_LB_pbsName,
	GLITE_JP_LB_pbsReason,
	GLITE_JP_LB_pbsScheduler,
	GLITE_JP_LB_pbsDestHost,
	GLITE_JP_LB_pbsPid,
	GLITE_JP_LB_pbsResourceRequested,
	GLITE_JP_LB_pbsResourceUsage,
	GLITE_JP_LB_pbsExitStatus,
	GLITE_JP_LB_pbsErrorDesc,
	GLITE_JP_LB_condorStatus,
	GLITE_JP_LB_condorUniverse,
	GLITE_JP_LB_condorOwner,
	GLITE_JP_LB_condorPreempting,
	GLITE_JP_LB_condorShadowPid,
	GLITE_JP_LB_condorShadowExitStatus,
	GLITE_JP_LB_condorStarterPid,
	GLITE_JP_LB_condorStarterExitStatus,
	GLITE_JP_LB_condorJobPid,
	GLITE_JP_LB_condorJobExitStatus,
	GLITE_JP_LB_condorDestHost,
	GLITE_JP_LB_condorReason,
	GLITE_JP_LB_condorErrorDesc,
	GLITE_JP_LB_creamState,
	GLITE_JP_LB_creamId,
	GLITE_JP_LB_creamOwner,
	GLITE_JP_LB_creamEndpoint,
	GLITE_JP_LB_creamJdl,
	GLITE_JP_LB_creamReason,
	GLITE_JP_LB_creamFailureReason,
	GLITE_JP_LB_creamLrmsId,
	GLITE_JP_LB_creamNode,
	GLITE_JP_LB_creamDoneCode,
	GLITE_JP_LB_creamExitCode,
	GLITE_JP_LB_creamCancelling,
	GLITE_JP_LB_creamCpuTime,
	GLITE_JP_LB_creamJwStatus,
	GLITE_JP_LB_ftComputeJob,
	GLITE_JP_LB_ftSandboxType,
	GLITE_JP_LB_ftSrc,
	GLITE_JP_LB_ftDest,
	GLITE_JP_LB_vmState,
	GLITE_JP_LB_vmImage,
	GLITE_JP_LB_vmRequire,
	GLITE_JP_LB_vmUsage,
	GLITE_JP_LB_vmHostname,
	GLITE_JP_LB_vmMachine,
	GLITE_JP_LB_vmId,
	GLITE_JP_LB_vmName,
	GLITE_JP_LB_vmPhyHostname,
	GLITE_JP_LB_vmSystemHalting,
	GLITE_JP_LB_vmManager,
};

#endif /* GLITE_LB_JOB_ATTRS2_H */
