/*!

	\file eef.h
	\brief API of the Nextgen library
	\author Aram Verstegen

	This header contains the delcaration of the Nextgen library functions:
	-# EEF_Init(): Starts the Nextgen library, which invokes the Evaluation Manager, which in turn invokes the PluginManager to load and init the required plugins.
	-# EEF_Run(plugin_name): Runs the Nextgen library, which iterates through the list and invokes the PluginManager to run the selected plugins.
	-# EEF_Term(): Terminates the Nextgen library, prompting a cleanup of the stored data in the AOS and plugin manager.

*/
#ifndef EEF_H
#define EEF_H
#include "config.h"
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#if HAVE_SYS_IOCTL_H || BSD
#include <sys/ioctl.h>
#endif


#include "eef_aos.h"
#include "eef_log.h"
#include "eef_return_codes.h"

#define BINARY_NAME "ees"
#define MAX_TIME_STRING_SIZE 256

/* lifecycle functions */

void                          fork_and_exit_parent_with_logging(void);
extern EES_RC  /*@alt void@*/ EEF_daemonize                    (void);
extern EES_RC  /*@alt void@*/ EEF_init(char *config_file, void (*log_func)(int, const char*, ...));
extern EES_RC  /*@alt void@*/ EEF_run                          (void);
extern EES_RC  /*@alt void@*/ EEF_term                         (void);
extern EES_RC  /*@alt void@*/ EEF_startThreading               (void);
unsigned int                  EEF_getMajorVersion              (void);
unsigned int                  EEF_getMinorVersion              (void);
unsigned int                  EEF_getPatchVersion              (void);
extern char*   /*@alt void@*/ EEF_getRunningPluginName         (void);

/* convenience methods */
const char*                   EEF_get_modules_path(void);
void                          EEF_set_modules_path(const char* path);

const char*                   EEF_get_log_file(void);
void                          EEF_set_log_file(const char* path);

int			      EEF_get_port(void);
void                          EEF_set_port(int port);
#endif

