/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimerTask;
import org.glite.authz.common.util.Files;
import org.glite.authz.common.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReloadTask
extends TimerTask {
    private Logger log = LoggerFactory.getLogger(LoggingReloadTask.class);
    private File loggingConfigFile;
    private long lastModification;

    public LoggingReloadTask(String configFilePath) throws IOException {
        String loggingConfigFilePath = Strings.safeTrimOrNullString(configFilePath);
        this.loggingConfigFile = Files.getReadableFile(loggingConfigFilePath);
        this.lastModification = -1L;
    }

    public void run() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        if (this.lastModification >= this.loggingConfigFile.lastModified()) {
            this.log.trace("Logging configuration has not changed, skipping reload");
            return;
        }
        try {
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            FileInputStream fin = new FileInputStream(this.loggingConfigFile);
            configurator.doConfigure((InputStream)fin);
            fin.close();
            loggerContext.start();
            this.log.info("Loaded new logging configuration file {}", (Object)this.loggingConfigFile.getAbsoluteFile());
            this.lastModification = this.loggingConfigFile.lastModified();
        }
        catch (JoranException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + this.loggingConfigFile.getAbsolutePath(), (Object)this, (Throwable)e));
        }
        catch (IOException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + this.loggingConfigFile.getAbsolutePath(), (Object)this, (Throwable)e));
        }
    }
}

