/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.logging;

import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.opensaml.xml.util.DatatypeHelper;

public class AccessLogEntry {
    private long requestTime = new DateTime().toDateTimeISO().getMillis();
    private String remoteHost;
    private String serverHost;
    private int serverPort;
    private String requestPath;

    public AccessLogEntry(HttpServletRequest request) {
        this.remoteHost = request.getRemoteHost();
        this.serverHost = request.getServerName();
        this.serverPort = request.getServerPort();
        String servletPath = request.getServletPath();
        this.requestPath = request.getPathInfo() == null ? servletPath : servletPath + request.getPathInfo();
    }

    public AccessLogEntry(String remote, String host, int port, String path) {
        this.remoteHost = DatatypeHelper.safeTrimOrNullString((String)remote);
        this.serverHost = DatatypeHelper.safeTrimOrNullString((String)host);
        this.serverPort = port;
        this.requestPath = DatatypeHelper.safeTrimOrNullString((String)path);
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String toString() {
        StringBuilder entryString = new StringBuilder();
        entryString.append(this.getRequestTime());
        entryString.append("|");
        entryString.append(this.getRemoteHost());
        entryString.append("|");
        entryString.append(this.getServerHost());
        entryString.append(":");
        entryString.append(this.getServerPort());
        entryString.append("|");
        entryString.append(this.getRequestPath());
        entryString.append("|");
        return entryString.toString();
    }
}

