/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettySslSelectChannelConnector
extends SslSelectChannelConnector {
    private Logger log = LoggerFactory.getLogger(JettySslSelectChannelConnector.class);
    private X509KeyManager keyManager;
    private X509TrustManager trustManager;

    public JettySslSelectChannelConnector(X509KeyManager key, X509TrustManager trust) {
        if (key == null) {
            throw new IllegalArgumentException("X.509 key manager may not be null");
        }
        this.keyManager = key;
        if (trust == null) {
            throw new IllegalArgumentException("X.509 trust manager may not be null");
        }
        this.trustManager = trust;
    }

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine sslEngine = super.createSSLEngine();
        String[] enabledCipherSuites = sslEngine.getEnabledCipherSuites();
        ArrayList<String> cipherSuites = new ArrayList<String>(Arrays.asList(enabledCipherSuites));
        for (String cipher : enabledCipherSuites) {
            if (!cipher.contains("ECDH")) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("disabling cipher: {}", (Object)cipher);
            }
            cipherSuites.remove(cipher);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("enabling ciphers: {}", cipherSuites);
        }
        enabledCipherSuites = cipherSuites.toArray(new String[cipherSuites.size()]);
        sslEngine.setEnabledCipherSuites(enabledCipherSuites);
        return sslEngine;
    }

    protected SSLContext createSSLContext() throws Exception {
        SSLContext sslConext = SSLContext.getInstance("TLS");
        sslConext.init(new KeyManager[]{this.keyManager}, new TrustManager[]{this.trustManager}, null);
        return sslConext;
    }
}

