class Unspecified(object):
    pass

unspecified = Unspecified()

class lazy_property(object):
    def __init__(self, func):
	self._func = func

    def __get__(self, other, _=None):
	if other is None:
	    return self
	else:
	    value = self._func(other)
	    setattr(other, self._func.func_name, value)
	    return value

def lazy_staticmethod(thunk):
    def g(cls):
	if not hasattr(cls, '_lazy_static'):
	    cls._lazy_static = {}
	h = hash(thunk)
	if not h in cls._lazy_static:
	    cls._lazy_static[h] = thunk()
	return cls._lazy_static[h]
    return classmethod(g)

class GetattrProxy(object):
    def __init__(self, *objs):
	self.objs = objs

    def __getitem__(self, k):
	for obj in self.objs:
	    try:
		return getattr(obj, k)
	    except AttributeError:
		pass

class Statdict(object):
    def __init__(self):
	self._d = {}
    def __getitem__(self, k):
	return self._d.get(k, 0)
    def __setitem__(self, k, v):
	self._d.__setitem__(k, v)
    def iteritems(self):
	return self._d.iteritems()
    def __bool__(self):
	return bool(self._d)
    def __len__(self):
	return len(self._d)

def options_of_spec(shortopts, longopts):
    def fix_longopt(longopt):
	if longopt.endswith('='):
	    return '--' + longopt[0:len(longopt)-1]
	else:
	    return '--' + longopt
    return ['-' + opt for opt in shortopts if opt != ':'] \
	 + map(fix_longopt, longopts)

def counted_noun(count, sing_word, pl_word = None):
    if count == 1:
	return '%d %s'%(count, sing_word)
    else:
	return '%d %s'%(count, pl_word or sing_word + 's')
