from arcnagios import arcutils, nagutils
from arcnagios.jobplugin import JobPlugin
import subprocess

def _split_url_urloptions(urlspec):
    if ';' in urlspec:
	xs = urlspec.split(';')
	return (xs[0], xs[1:])
    else:
	return (urlspec, [])

class StagingJobPlugin(JobPlugin):

    def staged_outputs(self):
	urls = self.getconf_strlist('staged_outputs', default = [])
	urls = map(_split_url_urloptions, urls)
	return [('%s-out-%d'%(self.test_name, i), url, urloptions)
		for i, (url, urloptions) in zip(range(0, len(urls)), urls)]

    def staged_inputs(self):
	urls = self.getconf_strlist('staged_inputs', default = [])
	urls = map(_split_url_urloptions, urls)
	return [('%s-in-%d'%(self.test_name, i), url, urloptions)
		for i, (url, urloptions) in zip(range(0, len(urls)), urls)]

    def write_script(self, fh):
	fh.write('# Test "%s" handled by the "staging" job-plugin.\n'
		 % self.test_name)
	for filename, _0, _1 in self.staged_outputs():
	    fh.write('hostname >%s\n'%filename)
	fh.write('\n')

    def check(self, report, jobdir, stored_urls):
	for url in stored_urls:
	    try:
		files = arcutils.arcls(url)
		if len(files) == 0:
		    report.log.error('Could not list %s.'%url)
		    report.update_states(nagutils.CRITICAL)
		elif len(files) > 1:
		    report.log.warning('Got multiple entries from %s:'%url)
		    for file in files:
			report.log.warning('  %s'%file)
	    except subprocess.CalledProcessError, xc:
		report.log.error('Failed to list %s using arcls: %s'%(url, xc))
		report.update_status(nagutils.CRITICAL)
