/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserListCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
        int countOfCurrentEnabledUser = ipmiMessagingCommand.getCountOfCurrentEnabledUser();
        MOut.println("Maximum number of Users          : " + numberOfAvailableUser);
        MOut.println("Count of currently enabled Users : " + countOfCurrentEnabledUser);
        String formatTemplate = "%8s | %-12s | %-18s | %-12s \n";
        MOut.printf(formatTemplate, "User ID", "User Name", "Privilege Level", "Enable");
        MOut.printf(formatTemplate, "-------", "---------", "---------------", "------");
        for (int i = 2; i <= numberOfAvailableUser; ++i) {
            String name = ipmiMessagingCommand.getUserNameByID((byte)i);
            byte privilege = ipmiMessagingCommand.getUserPrivilegeByID((byte)i);
            boolean isEnabled = ipmiMessagingCommand.isEnableUser((byte)i);
            MOut.printf(formatTemplate, "" + i, name, this.getPriviledgeString(privilege), isEnabled ? "Yes" : "No");
        }
        this.statusCode = 0;
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "CallBack";
            }
        }
        return "";
    }
}

