/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class SELListCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiSDRCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        MOut.println("Getting SDR records ...");
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        MOut.println("Getting SEL records ...");
        ArrayList list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
        int count = 0;
        if (list.size() != 0) {
            for (SELRecord item : list) {
                ArrayList raw = new ArrayList();
                MOut.println("------------------------------------------------------------------");
                MOut.print("Event:" + count);
                MOut.print(" Time:" + ByteUtility.fourByteToDate(item.getTimeStamp()));
                MOut.println(" Type:" + GlobalDefine.getSensorType(item.getSensorType() & 0xFF));
                if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197) {
                    MOut.print(GlobalDefine.getSensorType(item.getSensorType() & 0xFF) + " " + (byte)(item.getSensorNumber() & 0xFF));
                } else {
                    Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                    if (sensorName != null) {
                        MOut.print(sensorName.toString());
                    } else {
                        MOut.print("");
                    }
                }
                String reading = "";
                if (item.getEventType() == 1) {
                    byte offset = item.getEventData1();
                    double readingValue = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData2() & 0xFF);
                    double threshold = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData3() & 0xFF);
                    if (item.getSensorType() == 4) {
                        reading = reading + "\nReading = " + (int)readingValue + " RPM, Threshold = " + (int)threshold + " RPM";
                    } else if (item.getSensorType() == 2) {
                        reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " V, Threshold = " + String.format("%3.2f", threshold) + " V";
                    } else if (item.getSensorType() == 1) {
                        reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " C, Threshold = " + String.format("%3.2f", threshold) + " C";
                    }
                }
                MOut.println("  " + GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3()) + reading);
                ++count;
            }
        } else {
            MOut.println("SEL empty");
        }
        this.statusCode = 0;
    }
}

