/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class InfinibandStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte ibIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (ibIndex < 1 || ibIndex > 2) {
            MOut.println("Infiniband Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryInfiniBandEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        InfiniBandEntity ib = bladeSystem.getInfiniBands()[index - 1];
        if (ib.getPresent() == 0) {
            MOut.println("InfiniBand " + index + " is not present");
            this.statusCode = 151;
            return;
        }
        MOut.print(ib.toFormatedHeader());
        MOut.print(ib.toFormatedString());
        this.statusCode = 0;
    }
}

