/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIPowerCommand
extends SuperBladeCommand {
    private SubCommand subCommand = SubCommand.NO_COMMAND;
    private GlobalDefine.BootDevice bootDevice = GlobalDefine.BootDevice.BIOS;
    private byte cycleInterval = 0;

    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"up", "down", "softshutdown", "reset", "cycle"};
    }

    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = SubCommand.ON;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = SubCommand.OFF;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = SubCommand.GRACEFULSHUTDOWN;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = SubCommand.RESET;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("cycle")) {
                this.subCommand = SubCommand.CYCLE;
                passValidate = true;
            }
        } else {
            this.subCommand = SubCommand.NO_COMMAND;
            passValidate = true;
        }
        block0 : switch (this.subCommand) {
            case OFF: 
            case GRACEFULSHUTDOWN: 
            case RESET: {
                switch (this.parameters.length) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (this.parameters[1].equalsIgnoreCase("PXE")) {
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                            break block0;
                        }
                        passValidate = false;
                        break block0;
                    }
                }
                passValidate = false;
                break;
            }
        }
        block7 : switch (this.subCommand) {
            case CYCLE: {
                switch (this.parameters.length) {
                    case 1: {
                        break block7;
                    }
                    case 2: {
                        if (ByteUtility.isNumeric(this.parameters[1])) {
                            this.cycleInterval = Byte.valueOf(this.parameters[1]);
                            break block7;
                        }
                        if (this.parameters[1].equalsIgnoreCase("PXE")) {
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                            break block7;
                        }
                        passValidate = false;
                        break block7;
                    }
                    case 3: {
                        if (!this.parameters[1].equalsIgnoreCase("PXE")) {
                            passValidate = false;
                            break block7;
                        }
                        this.bootDevice = GlobalDefine.BootDevice.PXE;
                        if (ByteUtility.isNumeric(this.parameters[2])) {
                            this.cycleInterval = Byte.valueOf(this.parameters[2]);
                            break block7;
                        }
                        passValidate = false;
                        break block7;
                    }
                }
                passValidate = false;
                break;
            }
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.println("Available commands:");
        MOut.println("up                       power up system");
        MOut.println("down                     power down system");
        MOut.println("softshutdown             power softshotdown");
        MOut.println("reset [PXE]              power reset");
        MOut.println("cycle [i=10]             power cycle");
        MOut.println("");
        MOut.println("");
        MOut.println("");
        MOut.println("PXE option means that force boot device as PXE in next boot only");
        MOut.println("Ex: set power cycle interval as 10 seoncds and execute power cycle");
        MOut.println("IPMI>ipmi power cycle 10");
    }

    public void runCommand() throws Exception {
        boolean boolResult;
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        switch (this.bootDevice) {
            case PXE: {
                boolResult = ipmiChassisCommand.setBootDeviceOption(this.bootDevice);
                if (!boolResult) {
                    MOut.println("Set boot device failed");
                    this.statusCode = 149;
                    return;
                }
                boolResult = ipmiChassisCommand.keepBootFlagValidBit();
                if (boolResult) break;
                MOut.println("Can't keep boot flag valid bit");
                this.statusCode = 149;
                return;
            }
        }
        switch (this.subCommand) {
            case ON: {
                boolResult = ipmiChassisCommand.powerUp();
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case OFF: {
                boolResult = ipmiChassisCommand.powerDown();
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case GRACEFULSHUTDOWN: {
                boolResult = ipmiChassisCommand.softShutdown();
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case RESET: {
                boolResult = ipmiChassisCommand.reset();
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case CYCLE: {
                if (this.cycleInterval > 0 && !(boolResult = ipmiChassisCommand.setPowerCycleInterval(this.cycleInterval))) {
                    MOut.println("Set power cycle interval fail");
                    break;
                }
                boolResult = ipmiChassisCommand.powerCycle();
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case NO_COMMAND: {
                ACPIInfo acpi = ipmiGlobalCommand.getACPI();
                MOut.println("ACPI Power Status: " + acpi.getSystemStateInfo() + " (" + acpi.getSystemStateDescription() + ")");
                this.printUsage();
                this.statusCode = 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SubCommand {
        ON,
        OFF,
        GRACEFULSHUTDOWN,
        RESET,
        CYCLE,
        NO_COMMAND;

    }
}

