/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Host;
import com.supermicro.ipmi.text.HostManager;
import com.supermicro.ipmi.text.MOut;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindCommand
extends Command {
    public static HashMap foundDevice = new LinkedHashMap();
    public static Calendar lastUpdate;

    @Override
    public void execute() {
        if (this.parameters != null) {
            if (this.parameters.length != 3) {
                MOut.println("parameter error!");
                this.statusCode = 147;
                return;
            }
            String startIP = this.parameters[0];
            String endIP = this.parameters[1];
            String netMask = this.parameters[2];
            this.findIPMIDevice(startIP, endIP, netMask);
        } else {
            this.findLocalIPMIDevice();
        }
        this.statusCode = 0;
    }

    public void findIPMIDevice(String startIP, String endIP, String netMask) {
        try {
            ArrayList<String> list = this.allAddress(startIP, endIP, netMask);
            ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
            this.findIPMIDevice(devices);
        }
        catch (Exception ex) {
            MOut.println(ex.getMessage());
            return;
        }
    }

    public void findLocalIPMIDevice() {
        ArrayList<String> list = this.findLocalIPs();
        ArrayList<FindDevice> devices = this.getAllPossibleIPMIDevice(list);
        this.findIPMIDevice(devices);
    }

    public void findIPMIDevice(ArrayList<FindDevice> devices) {
        MOut.println("Finding IPMI Devices ...");
        for (int i = 0; i < devices.size(); ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            devices.get(i).start();
        }
        try {
            Thread.sleep(18000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        boolean isFoundAny = false;
        int deviceCount = 0;
        for (int i = 0; i < devices.size(); ++i) {
            if (!devices.get((int)i).doneGet) continue;
            ++deviceCount;
            MOut.println(devices.get(i).toString());
            foundDevice.put(devices.get((int)i).ip, devices.get((int)i).type);
            isFoundAny = true;
            Host host = HostManager.getInstance().findHost(devices.get((int)i).ip);
            if (host != null) continue;
            host = new Host();
            host.setName(devices.get((int)i).ip);
            host.setIp(devices.get((int)i).ip);
            try {
                HostManager.getInstance().addHost(host);
                continue;
            }
            catch (Exception ex1) {
                MOut.println(ex1.getMessage());
            }
        }
        if (!isFoundAny) {
            MOut.println("No IPMI Device found!");
        } else {
            MOut.println("" + deviceCount + " IPMI device(s) found. Use \"found\" to list found devices");
        }
        lastUpdate = Calendar.getInstance();
    }

    public ArrayList<FindDevice> getAllPossibleIPMIDevice(ArrayList<String> list) {
        ArrayList<FindDevice> devices = new ArrayList<FindDevice>();
        for (int i = 0; i < list.size(); ++i) {
            FindDevice device = new FindDevice(list.get(i), 8, 2);
            devices.add(device);
        }
        return devices;
    }

    public ArrayList<String> findLocalIPs() {
        ArrayList<String> ips = new ArrayList<String>();
        InetAddress[] ia = null;
        try {
            ia = this.getAllLocalUsingNetworkInterface();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        for (int i = 0; i < ia.length; ++i) {
            ArrayList<String> l = this.allAddress(ia[i].getHostAddress());
            ips.addAll(l);
        }
        return ips;
    }

    private InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }

    public ArrayList<String> allAddress(String ip) {
        ArrayList<String> list = new ArrayList<String>();
        if (IPMILanCommand.isIPAddress(ip) && !ip.equals("127.0.0.1")) {
            String cClass = ip.substring(0, ip.lastIndexOf("."));
            for (int i = 1; i < 255; ++i) {
                list.add(cClass + "." + i);
            }
        }
        return list;
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        InetAddress startInet = InetAddress.getByName(startIP);
        InetAddress endInet = InetAddress.getByName(endIP);
        InetAddress maskInet = InetAddress.getByName(netmask);
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i = startInet.hashCode(); i <= endInet.hashCode(); ++i) {
            list.add(this.intToIP(i));
        }
        return list;
    }

    public String intToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    public void findTest() {
        FindDevice device = new FindDevice("192.168.10.240", 5, 2);
        device.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (device.doneGet) {
            MOut.println(device.toString());
        }
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        FindCommand f = new FindCommand();
        InetAddress saddress = null;
        try {
            saddress = InetAddress.getByName("192.168.10.1");
            MOut.println(f.intToIP(saddress.hashCode() + 1));
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        System.out.println(saddress.hashCode());
        try {
            ArrayList<String> list = f.allAddress("192.168.1.1", "192.168.1.24", "255.255.255.0");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println((Object)list.get(i));
            }
        }
        catch (Exception ex1) {
            MOut.println(ex1.getMessage());
        }
    }

    class FindDevice
    extends Thread {
        public String ip;
        public String type;
        boolean doneGet = false;
        int timeout;
        int retry;
        IPMIInterfaceConfig config;

        public FindDevice(String ip) {
            this(ip, 5, 1);
        }

        public FindDevice(String ip, int timeout, int retry) {
            this.ip = ip;
            this.timeout = timeout;
            this.retry = retry;
            this.config = new IPMIInterfaceConfig();
            this.config.setIp(ip);
            this.config.setTimeout(timeout);
            this.config.setRetry(retry);
        }

        public void run() {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.ip, this.timeout, this.retry);
            if (guid != null) {
                this.type = IPMIMessagingCommand.isCMMGUID(guid) ? (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid) ? "IPMI 2.0 (SuperBlade OfficeBlade CMM)" : "IPMI 2.0 (SuperBlade CMM)") : (IPMIMessagingCommand.isSIMBL(guid) ? "IPMI 2.0 (SIMBL)" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "IPMI 2.0 (SIM IPMI+KVM)" : (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) ? "IPMI 2.0 (SIM IPMI+KVM)" : (IPMIMessagingCommand.isOSAGUID(guid) ? "IPMI 2.0 (SUPERO IPMI)" : "IPMI"))));
                this.doneGet = true;
            }
        }

        public String toString() {
            String format = "  %-20s \t %-20s";
            String retStr = String.format(format, this.ip, this.type);
            return retStr;
        }
    }
}

