/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCIPSettingCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.println("blade Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.println("Blade " + bladeIndex + " is not present");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            if (this.parameters != null && this.parameters.length == 1) {
                String newIP = this.parameters[0];
                if (!IPMILanCommand.isIPAddress(newIP)) {
                    MOut.println("IP format error!");
                    this.statusCode = 147;
                    return;
                }
                if (newIP.equals("0.0.0.0")) {
                    MOut.println("IP cannot be 0.0.0.0!");
                    this.statusCode = 147;
                    return;
                }
                boolean b = this.writeSIMBLIP(newIP);
                if (b) {
                    MOut.println("Done");
                    this.statusCode = 0;
                } else {
                    MOut.println("Failed");
                    this.statusCode = 149;
                }
            } else if (bladeSystem.isIsSupportIPMB()) {
                this.showSIMBLIP();
                this.statusCode = 0;
            } else {
                MOut.println("BMC installed, but cannot get IP");
                this.statusCode = 149;
            }
        } else {
            MOut.println("BMC Not Installed");
            this.statusCode = 149;
        }
    }

    public void showSIMBLIP() {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.sessionController != null) {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                MOut.println(ip);
            } else {
                MOut.println("BMC Installed");
            }
        }
    }

    public boolean writeSIMBLIP(String ip) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        boolean b = false;
        b = ipmiLanCommand.setIP(ip);
        return b;
    }
}

