/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import java.util.Observable;

public class BladeEntity
extends Observable {
    public static final byte MB_B7DBE = 0;
    public static final byte MB_BHQME = 1;
    public static final byte MB_B7DW3 = 2;
    public static final byte MB_B7DCE = 3;
    public static final byte MB_B7DC3 = 4;
    public static final byte MB_BHDME = 5;
    private boolean simCardDetectPin;
    private boolean v3_3v;
    private boolean i2cSMBEnable;
    private boolean v12vEnable;
    private boolean powerReqeust;
    private boolean clearPowerRequest;
    private boolean kvmRequest;
    private boolean clearKVMRequest;
    private boolean m1KVMEnable;
    private boolean m2KVMEnable;
    private boolean resetButton;
    private boolean powerButton;
    private boolean reducedPower;
    private boolean error1LED;
    private boolean uid_kvm_LED;
    private boolean error2LED;
    private byte i2cError;
    private byte present;
    private byte kvmEnable;
    private byte uidEnable;
    private byte powerWatt;
    private byte initialized;
    private byte channel;
    private byte busNumber;
    private byte pwrState;
    private byte miscFlag;
    private byte selReportError1;
    private byte selReportError2;
    private byte biosUpCountDown;
    private byte simblTimeFlag1;
    private byte simblTimeFlag2;
    private byte mbModel;
    private byte[] raw;
    private int moduleIndex;

    public int getWattByFormula() {
        return (0xFF & this.powerWatt) * 25;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nsimCardDetectPin =" + this.simCardDetectPin);
        sb.append("\nv3_3v =" + this.v3_3v);
        sb.append("\ni2cSMBEnable =" + this.i2cSMBEnable);
        sb.append("\nv12vEnable =" + this.v12vEnable);
        sb.append("\npowerReqeust =" + this.powerReqeust);
        sb.append("\nclearPowerRequest =" + this.clearPowerRequest);
        sb.append("\nkvmRequest =" + this.kvmRequest);
        sb.append("\nclearKVMRequest =" + this.clearKVMRequest);
        sb.append("\nm1KVMEnable =" + this.m1KVMEnable);
        sb.append("\nm2KVMEnable =" + this.m2KVMEnable);
        sb.append("\nresetButton =" + this.resetButton);
        sb.append("\npowerButton =" + this.powerButton);
        sb.append("\nReducePower =" + this.reducedPower);
        sb.append("\nerror1LED =" + this.error1LED);
        sb.append("\nuid_kvm_LED =" + this.uid_kvm_LED);
        sb.append("\nOVT =" + this.error2LED);
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\npresent =" + this.present);
        sb.append("\nkvmEnable =" + this.kvmEnable);
        sb.append("\nuidEnable =" + this.uidEnable);
        sb.append("\npowerWatt =" + this.powerWatt);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\nchannel =" + this.channel);
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nPwrState =" + this.pwrState);
        sb.append("\nmiscFlag =" + this.miscFlag);
        sb.append("\nSELReportError =" + this.selReportError1 + " " + this.selReportError2);
        sb.append("\nbiosUpCountDown =" + this.biosUpCountDown);
        sb.append("\nsimblTimeFlag =" + this.simblTimeFlag1 + " " + this.simblTimeFlag2);
        sb.append("\nmbModel =" + this.mbModel);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 18) {
            return false;
        }
        try {
            this.simCardDetectPin = (raw[0] & 1) == 1;
            this.v3_3v = (raw[0] & 2) == 2;
            this.i2cSMBEnable = (raw[0] & 4) == 4;
            this.v12vEnable = (raw[0] & 8) == 8;
            this.powerReqeust = (raw[0] & 0x10) == 16;
            this.clearPowerRequest = (raw[0] & 0x20) == 32;
            this.kvmRequest = (raw[0] & 0x40) == 64;
            this.clearKVMRequest = (raw[0] & 0x80) == 128;
            this.m1KVMEnable = (raw[1] & 1) == 1;
            this.m2KVMEnable = (raw[1] & 2) == 2;
            this.resetButton = (raw[1] & 4) == 4;
            this.powerButton = (raw[1] & 8) == 8;
            this.reducedPower = (raw[1] & 0x10) == 16;
            this.error1LED = (raw[1] & 0x20) == 32;
            this.uid_kvm_LED = (raw[1] & 0x40) == 64;
            this.error2LED = (raw[1] & 0x80) == 128;
            this.i2cError = raw[2];
            this.present = raw[3];
            this.kvmEnable = raw[4];
            this.uidEnable = raw[5];
            this.powerWatt = raw[6];
            this.initialized = raw[7];
            this.channel = raw[8];
            this.busNumber = raw[9];
            this.pwrState = raw[10];
            this.miscFlag = raw[11];
            this.selReportError1 = raw[12];
            this.selReportError2 = raw[13];
            this.biosUpCountDown = raw[14];
            this.simblTimeFlag1 = raw[15];
            this.simblTimeFlag2 = raw[16];
            this.mbModel = raw[17];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public boolean isClearKVMRequest() {
        return this.clearKVMRequest;
    }

    public boolean isClearPowerRequest() {
        return this.clearPowerRequest;
    }

    public boolean isError1LED() {
        return this.error1LED;
    }

    public boolean isError2LED() {
        return this.error2LED;
    }

    public boolean isI2cSMBEnable() {
        return this.i2cSMBEnable;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getKvmEnable() {
        return this.kvmEnable;
    }

    public boolean isKvmRequest() {
        return this.kvmRequest;
    }

    public boolean isM1KVMEnable() {
        return this.m1KVMEnable;
    }

    public boolean isM2KVMEnable() {
        return this.m2KVMEnable;
    }

    public boolean isPowerButton() {
        return this.powerButton;
    }

    public boolean isPowerReqeust() {
        return this.powerReqeust;
    }

    public byte getPowerWatt() {
        return this.powerWatt;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public boolean isReducedPower() {
        return this.reducedPower;
    }

    public boolean isResetButton() {
        return this.resetButton;
    }

    public boolean isSimCardDetectPin() {
        return !this.simCardDetectPin;
    }

    public boolean isUid_kvm_LED() {
        return this.uid_kvm_LED;
    }

    public byte getUidEnable() {
        return this.uidEnable;
    }

    public boolean isV12vEnable() {
        return this.v12vEnable;
    }

    public boolean isV3_3v() {
        return this.v3_3v;
    }

    public byte getMBModel() {
        return this.mbModel;
    }

    public String getMBModelName() {
        String name = null;
        switch (this.mbModel) {
            case 0: {
                name = "B7DBE";
                break;
            }
            case 1: {
                name = "BHQME";
                break;
            }
            case 2: {
                name = "B7DW3";
                break;
            }
            case 3: {
                name = "B7DCE";
                break;
            }
            case 4: {
                name = "B7DC3";
                break;
            }
            case 5: {
                name = "BHDME";
                break;
            }
            default: {
                name = "Undefined";
            }
        }
        return name;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getBiosUpCountDown() {
        return this.biosUpCountDown;
    }

    public byte getMiscFlag() {
        return this.miscFlag;
    }

    public byte getPwrState() {
        return this.pwrState;
    }

    public byte getSelReportError1() {
        return this.selReportError1;
    }

    public byte getSelReportError2() {
        return this.selReportError2;
    }

    public byte getSimblTimeFlag1() {
        return this.simblTimeFlag1;
    }

    public byte getSimblTimeFlag2() {
        return this.simblTimeFlag2;
    }

    public void setV3_3v(boolean v3_3v) {
        this.v3_3v = v3_3v;
    }

    public void setV12vEnable(boolean v12vEnable) {
        this.v12vEnable = v12vEnable;
    }

    public void setUidEnable(byte uidEnable) {
        this.uidEnable = uidEnable;
    }

    public void setUid_kvm_LED(boolean uid_kvm_LED) {
        this.uid_kvm_LED = uid_kvm_LED;
    }

    public void setSimCardDetectPin(boolean simCardDetectPin) {
        this.simCardDetectPin = simCardDetectPin;
    }

    public void setResetButton(boolean resetButton) {
        this.resetButton = resetButton;
    }

    public void setReducedPower(boolean reducedPower) {
        this.reducedPower = reducedPower;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setPowerWatt(byte powerWatt) {
        this.powerWatt = powerWatt;
    }

    public void setPowerReqeust(boolean powerReqeust) {
        this.powerReqeust = powerReqeust;
    }

    public void setPowerButton(boolean powerButton) {
        this.powerButton = powerButton;
    }

    public void setM2KVMEnable(boolean m2KVMEnable) {
        this.m2KVMEnable = m2KVMEnable;
    }

    public void setM1KVMEnable(boolean m1KVMEnable) {
        this.m1KVMEnable = m1KVMEnable;
    }

    public void setKvmRequest(boolean kvmRequest) {
        this.kvmRequest = kvmRequest;
    }

    public void setKvmEnable(byte kvmEnable) {
        this.kvmEnable = kvmEnable;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setI2cSMBEnable(boolean i2cSMBEnable) {
        this.i2cSMBEnable = i2cSMBEnable;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setError1LED(boolean error1LED) {
        this.error1LED = error1LED;
    }

    public void setError2LED(boolean error2LED) {
        this.error2LED = error2LED;
    }

    public void setClearPowerRequest(boolean clearPowerRequest) {
        this.clearPowerRequest = clearPowerRequest;
    }

    public void setClearKVMRequest(boolean clearKVMRequest) {
        this.clearKVMRequest = clearKVMRequest;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setMbModel(byte mbModel) {
        this.mbModel = mbModel;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setBiosUpCountDown(byte biosUpCountDown) {
        this.biosUpCountDown = biosUpCountDown;
    }

    public void setMiscFlag(byte miscFlag) {
        this.miscFlag = miscFlag;
    }

    public void setPwrState(byte pwrState) {
        this.pwrState = pwrState;
    }

    public void setSelReportError1(byte selReportError1) {
        this.selReportError1 = selReportError1;
    }

    public void setSelReportError2(byte selReportError2) {
        this.selReportError2 = selReportError2;
    }

    public void setSimblTimeFlag1(byte simblTimeFlag1) {
        this.simblTimeFlag1 = simblTimeFlag1;
    }

    public void setSimblTimeFlag2(byte simblTimeFlag2) {
        this.simblTimeFlag2 = simblTimeFlag2;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-8s | %-6s | %-8s | %-3s | %-5s | %-3s | %4s | %-9s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Blade", "Power", "KVM", "UID", "Error", "BMC", "Watt", "MB"));
        header.append(String.format(formatTemplate, "-----", "-----", "---", "---", "-----", "---", "----", "--"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-8s | %-6s | %-8s | %-3s | %-5s | %-3s | %4s | %-9s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "Blade " + this.moduleIndex;
        String power = this.isV12vEnable() && this.isV3_3v() ? "On" : "Off";
        String kvm = this.getKvmEnable() > 0 ? "Selected" : "";
        String uid = this.getUidEnable() > 0 ? "On" : "";
        String error = this.isError1LED() ? "Error" : "";
        String management = this.isSimCardDetectPin() ? "Yes" : "";
        String watt = this.getWattByFormula() + "W";
        String mb = this.getMBModelName();
        formatedString.append(String.format(formatTemplate, index, power, kvm, uid, error, management, watt, mb));
        return formatedString.toString();
    }
}

