/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.FRU;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMIFRUCommand
extends IPMICommand {
    public IPMIFRUCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getFRUInventoryAreaInfoCommand(byte fruDeviceID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{fruDeviceID};
        ipmiMessage.setCommandAndData((byte)40, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readFRUDataCommand(byte fruDeviceID, byte[] offset, byte countToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        data[1] = fruDeviceID;
        System.arraycopy(offset, 0, data, 1, 2);
        data[3] = countToRead;
        ipmiMessage.setCommandAndData((byte)40, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeFRUDataCommand(byte fruDeviceID, byte[] offset, byte[] buffer) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + buffer.length];
        data[1] = fruDeviceID;
        System.arraycopy(offset, 0, data, 1, 2);
        System.arraycopy(buffer, 0, data, 3, buffer.length);
        ipmiMessage.setCommandAndData((byte)40, (byte)18, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage lockFRUCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)6, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage unlockFRUCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)6, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public int getFRUSize() {
        IPMIMessage resMessage = this.getFRUInventoryAreaInfoCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                int size = 0;
                size = resMessage.data[0] + resMessage.data[1] << 8;
                if (resMessage.data[2] == 1) {
                    size *= 2;
                }
                return size;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute GET FRU Inventory Area Info");
        return 0;
    }

    public FRUInfo getFRUData() {
        int size = this.getFRUSize();
        if (size == 0) {
            return null;
        }
        byte[] data = new byte[size];
        boolean count = false;
        for (int i = 0; i < size - 22; i += 22) {
            MessageCenter.getInstance().put(this, (Object)("Read FRU segment (" + i + ")"));
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            IPMIMessage resMessage = this.readFRUDataCommand((byte)0, offset, (byte)22);
            if (resMessage == null) continue;
            if (resMessage.completionCode == 0) {
                byte[] dataSegment = new byte[resMessage.data[0]];
                System.arraycopy(resMessage.data, 1, dataSegment, 0, dataSegment.length);
                System.arraycopy(dataSegment, 0, data, i, dataSegment.length);
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        return FRUInfo.fromRaw(data);
    }

    public boolean writeFRU(FRU fru) {
        byte[] raw = fru.toRaw();
        if (!this.unlockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not unlock FRU data");
            return false;
        }
        byte[] buffer = new byte[8];
        for (int i = 0; i < raw.length; i += 8) {
            byte[] offset = new byte[]{(byte)(i & 0xFF), (byte)((i & 0xFF00) >> 8)};
            System.arraycopy(raw, i, buffer, 0, 8);
            IPMIMessage resMessage = this.writeFRUDataCommand((byte)0, offset, buffer);
            int i_offset = offset[1];
            int i_offset_ls = offset[0] & 0xFF;
            i_offset <<= 8;
            i_offset &= 0xFF00;
            MessageCenter.getInstance().put(this, (Object)("Writing FRU data Offset : " + (i_offset += i_offset_ls)));
            if (resMessage.completionCode == 0) continue;
            MessageCenter.getInstance().put(this, (Object)"Failed to Write FRU data");
            return false;
        }
        if (!this.lockFRU()) {
            MessageCenter.getInstance().put(this, (Object)"Could not lock FRU data");
            return false;
        }
        return true;
    }

    public boolean lockFRU() {
        IPMIMessage resMessage = this.lockFRUCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute lock FRU Command");
        return false;
    }

    public boolean unlockFRU() {
        IPMIMessage resMessage = this.unlockFRUCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute unlock FRU Command");
        return false;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.237");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiFRUCommand.setIPMIInterface(rmcp);
        int size = ipmiFRUCommand.getFRUSize();
        System.out.println("size =" + size);
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
        if (fruInfo != null) {
            System.out.println(fruInfo.toString());
        }
        byte[] b1 = fruInfo.fru.board.boardManufacturer;
        byte[] b2 = fruInfo.fru.board.boardPartNumber;
        byte[] b3 = fruInfo.fru.board.boardProductName;
        byte[] b4 = fruInfo.fru.board.boardSerialNumber;
        byte[] b5 = fruInfo.fru.product.productManufacturerName;
        byte[] b6 = fruInfo.fru.product.productName;
        byte[] b7 = fruInfo.fru.product.productPartModelNumber;
        byte[] b8 = fruInfo.fru.product.productSerialNumber;
        byte[] b9 = fruInfo.fru.product.productVersion;
        System.out.println(new String(b1));
        System.out.println(new String(b2));
        System.out.println(new String(b3));
        System.out.println(new String(b4));
        System.out.println(new String(b5));
        System.out.println(new String(b6));
        System.out.println(new String(b7));
        System.out.println(new String(b8));
        System.out.println(new String(b9));
        fruInfo.fru.board.boardManufacturer = "1".getBytes();
        fruInfo.fru.board.boardPartNumber = "2".getBytes();
        fruInfo.fru.board.boardProductName = "3".getBytes();
        fruInfo.fru.board.boardSerialNumber = "4".getBytes();
        fruInfo.fru.product.productManufacturerName = "a".getBytes();
        fruInfo.fru.product.productName = "b".getBytes();
        fruInfo.fru.product.productPartModelNumber = "c".getBytes();
        fruInfo.fru.product.productSerialNumber = "d".getBytes();
        fruInfo.fru.product.productVersion = "e".getBytes();
        sessionController.closeSession();
    }
}

