/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserDeleteCommand
extends SuperBladeCommand {
    byte userID;

    public boolean preValidate() {
        String usage = "Usage: user delete <user id> \n";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.println("user id should be number");
            MOut.println(usage);
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte privilege = ipmiMessagingCommand.getUserPrivilegeByID(this.userID);
        boolean b1 = ipmiMessagingCommand.setUserNameByID(this.userID, "");
        if (!b1) {
            MOut.println("clear user name failed");
            this.statusCode = 149;
            return;
        }
        boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, "");
        if (!b2) {
            MOut.println("Set user password failed");
            this.statusCode = 149;
            return;
        }
        boolean b3 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, (byte)0);
        if (!b3) {
            MOut.println("clear user privilege failed");
            this.statusCode = 149;
            return;
        }
        boolean b4 = ipmiMessagingCommand.setDisableUserByID(this.userID);
        if (!b4) {
            MOut.println("disable user failed");
            this.statusCode = 149;
            return;
        }
        boolean b5 = ipmiMessagingCommand.setDisableUserPlusByID(this.userID, (byte)0);
        if (!b5) {
            MOut.println("disable user(+) failed");
            this.statusCode = 149;
            return;
        }
        MOut.println("Done");
        this.statusCode = 0;
    }
}

