/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.Trap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class TrapSavePETCommand
extends Command {
    public void execute() throws Exception {
        int sizeOfTrap = Receiver.getInstance().getTrapCollector().getTraps().size();
        if (sizeOfTrap == 0) {
            MOut.println("No trap received");
            this.statusCode = 0;
            return;
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.print("Filename required");
            this.statusCode = 147;
            return;
        }
        String filename = this.parameters[0];
        boolean result = this.save(filename);
        if (result) {
            MOut.print("\"" + filename + "\" file saved");
        } else {
            MOut.print("save \"" + filename + "\" file failed");
        }
        this.statusCode = 0;
    }

    public boolean save(String filename) {
        String fileVersion = "supermicro-trap-v1";
        File f = new File(filename);
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        dos = new DataOutputStream(fos);
        try {
            dos.writeBytes(fileVersion);
            for (int i = 0; i < Receiver.getInstance().getTrapCollector().getTraps().size(); ++i) {
                Trap trap = (Trap)Receiver.getInstance().getTrapCollector().getTraps().get(i);
                dos.writeByte(trap.getDataLength());
                dos.write(trap.getDataBuff(), 0, trap.getDataLength());
            }
            dos.close();
            fos.close();
        }
        catch (IOException ex1) {
            // empty catch block
        }
        return true;
    }
}

