/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.Trap;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class TrapSaveCommand
extends Command {
    public void execute() throws Exception {
        int sizeOfTrap = Receiver.getInstance().getTrapCollector().getTraps().size();
        if (sizeOfTrap == 0) {
            MOut.println("No trap received");
            this.statusCode = 0;
            return;
        }
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.print("Filename required");
            this.statusCode = 147;
            return;
        }
        String filename = this.parameters[0];
        boolean result = this.save(filename);
        if (result) {
            MOut.print("\"" + filename + "\" file saved");
        } else {
            MOut.print("save \"" + filename + "\" file failed");
        }
        this.statusCode = 0;
    }

    public boolean save(String filename) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(filename);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        for (int i = 0; i < Receiver.getInstance().getTrapCollector().getTraps().size(); ++i) {
            Trap trap = (Trap)Receiver.getInstance().getTrapCollector().getTraps().get(i);
            ps.println("\n-------------------------------------------------------------------------");
            ps.print("Trap (" + (i + 1) + ")");
            ps.print(trap.toString());
        }
        ps.close();
        return true;
    }
}

