/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMBoardIDCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        String mbName;
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 2) {
            byte[] productID = new byte[2];
            try {
                productID[0] = (byte)Integer.parseInt(this.parameters[0], 16);
                productID[1] = (byte)Integer.parseInt(this.parameters[1], 16);
                boolean result = ipmiOEMCommand.setProductID(productID);
                if (result) {
                    MOut.println("Done");
                    this.statusCode = 0;
                } else {
                    MOut.println("Failed");
                    this.statusCode = 149;
                }
                return;
            }
            catch (NumberFormatException ex) {
                MOut.println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
        }
        byte[] bytes = ipmiOEMCommand.getBoardModelByte();
        if (bytes == null) {
            MOut.println("This device does not support this OEM command");
            this.statusCode = 153;
            return;
        }
        MOut.println(ByteUtility.bytesToHex(bytes));
        this.statusCode = 0;
        if (this.parameters != null && this.parameters[0].equalsIgnoreCase("name") && (mbName = ipmiOEMCommand.getBoardModel()) != null) {
            MOut.println("Model Number : " + mbName);
            this.statusCode = 0;
        }
    }
}

