/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanNetmaskCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String mask = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(mask)) {
                MOut.println("Netmask format error!");
                this.statusCode = 147;
                return;
            }
            if (mask.equals("0.0.0.0")) {
                MOut.println("Netmask cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            int intValue = ByteUtility.ipToInt(mask);
            if (((0 - intValue & intValue) - 1 | intValue) != -1) {
                MOut.println("Wrong netmask!");
                this.statusCode = 147;
                return;
            }
            String oldMask = ipmiLanCommand.getSubnetMask();
            boolean result = ipmiLanCommand.setSubnetMask(mask);
            if (result) {
                MOut.println("old Netmask:" + oldMask);
                MOut.println("new Netmask:" + mask);
                this.statusCode = 0;
            } else {
                MOut.println(oldMask);
                MOut.println("Update Netmask failed");
                this.statusCode = 149;
            }
        } else {
            String mask = ipmiLanCommand.getSubnetMask();
            MOut.println(mask);
            this.statusCode = 0;
        }
    }
}

