/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class GBWSSCommand
extends SuperBladeCommand {
    public static final int IP = 0;
    public static final int NETMASK = 1;
    public static final int GATEWAY = 2;
    public static final int DATETIME = 3;
    public static final int USERNAME = 4;
    public static final int PASSWORD = 5;
    private int subCommand = -1;

    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"ip", "netmask", "gateway", "datetime", "username", "password"};
    }

    public boolean preValidate() {
        boolean passValidate = false;
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            System.out.println("Gigabit switch Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("ip")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("netmask")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("gateway")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("datetime")) {
                this.subCommand = 3;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("username")) {
                this.subCommand = 4;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("password")) {
                this.subCommand = 5;
                passValidate = true;
            }
        }
        if (!passValidate) {
            MOut.println("Available command: ");
            MOut.println("ip []");
            MOut.println("netmask []");
            MOut.println("gateway []");
            MOut.println("datetime []");
            MOut.println("username []");
            MOut.println("password []");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isGigabitPresent(gbIndex)) {
            MOut.println("Gigabit Switch " + gbIndex + " is not present");
            this.statusCode = 151;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                if (this.parameters.length == 1) {
                    this.showData(0, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setIP(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
                break;
            }
            case 1: {
                if (this.parameters.length == 1) {
                    this.showData(1, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setNetmask(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
                break;
            }
            case 2: {
                if (this.parameters.length == 1) {
                    this.showData(2, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setGateway(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
                break;
            }
            case 3: {
                if (this.parameters.length == 1) {
                    this.showData(3, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setDatetime(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
                break;
            }
            case 4: {
                if (this.parameters.length == 1) {
                    this.showData(4, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setUsername(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
                break;
            }
            case 5: {
                if (this.parameters.length == 1) {
                    this.showData(5, gbIndex, this.ipmiCMMOEMCommand);
                    break;
                }
                this.setPassword(gbIndex, this.ipmiCMMOEMCommand, this.parameters[1]);
            }
        }
    }

    public void showData(int subCommand, int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand) throws Exception {
        String data = null;
        switch (subCommand) {
            case 0: {
                data = ipmiCMMOEMCommand.getGBIP((byte)gbIndex);
                MOut.println(data);
                break;
            }
            case 1: {
                data = ipmiCMMOEMCommand.getGBNetMask((byte)gbIndex);
                MOut.println(data);
                break;
            }
            case 2: {
                data = ipmiCMMOEMCommand.getGBGateway((byte)gbIndex);
                MOut.println(data);
                break;
            }
            case 3: {
                Calendar c = ipmiCMMOEMCommand.getGBTime((byte)gbIndex);
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                data = f.format(c.getTime());
                MOut.println(data);
                break;
            }
            case 4: {
                data = ipmiCMMOEMCommand.getGBUsername((byte)gbIndex);
                MOut.println(data);
                break;
            }
            case 5: {
                data = ipmiCMMOEMCommand.getGBPassword((byte)gbIndex);
                MOut.println(data);
            }
        }
        this.statusCode = 0;
    }

    public void setIP(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String ip) throws Exception {
        if (!IPMILanCommand.isIPAddress(ip)) {
            MOut.println("IP format error!");
            this.statusCode = 147;
            return;
        }
        if (ip.equals("0.0.0.0")) {
            MOut.println("IP cannot be 0.0.0.0!");
            this.statusCode = 147;
            return;
        }
        boolean result = ipmiCMMOEMCommand.setGBIP((byte)gbIndex, ip);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }

    public void setNetmask(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(netmask)) {
            MOut.println("Netmask format error!");
            this.statusCode = 147;
            return;
        }
        if (netmask.equals("0.0.0.0")) {
            MOut.println("Netmask cannot be 0.0.0.0!");
            this.statusCode = 147;
            return;
        }
        int intValue = ByteUtility.ipToInt(netmask);
        if (((0 - intValue & intValue) - 1 | intValue) != -1) {
            MOut.println("Wrong netmask!");
            this.statusCode = 147;
            return;
        }
        boolean result = ipmiCMMOEMCommand.setGBNetMask((byte)gbIndex, netmask);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }

    public void setGateway(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String gateway) throws Exception {
        if (!IPMILanCommand.isIPAddress(gateway)) {
            MOut.println("Gateway format error!");
            this.statusCode = 147;
            return;
        }
        if (gateway.equals("0.0.0.0")) {
            MOut.println("Gateway cannot be 0.0.0.0!");
            this.statusCode = 147;
            return;
        }
        boolean result = ipmiCMMOEMCommand.setGBGateway((byte)gbIndex, gateway);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }

    public void setDatetime(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String datetime) throws Exception {
        Calendar c = Calendar.getInstance();
        try {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            f.setLenient(false);
            Date date = f.parse(datetime);
            c.setTime(date);
        }
        catch (ParseException ex1) {
            MOut.println("Format error! " + ex1.getMessage());
            MOut.println("Format: MM/dd/yyyy HH:mm:ss");
            MOut.println("Example:\"05/07/2007 17:17:06\"");
            this.statusCode = 147;
            return;
        }
        boolean result = ipmiCMMOEMCommand.setGBTime((byte)gbIndex, c);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }

    public void setUsername(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String username) throws Exception {
        boolean result = ipmiCMMOEMCommand.setGBUsername((byte)gbIndex, username);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }

    public void setPassword(int gbIndex, IPMICMMOEMCommand ipmiCMMOEMCommand, String password) throws Exception {
        boolean result = ipmiCMMOEMCommand.setGBPassword((byte)gbIndex, password);
        boolean result2 = ipmiCMMOEMCommand.setGBCommit((byte)gbIndex);
        if (result && result2) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }
}

