/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBPowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int RESET = 2;
    private int subCommand = -1;

    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"on", "off", "reset"};
    }

    public boolean preValidate() {
        boolean passValidate = false;
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            MOut.println("Gigabit switch Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("on")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("off")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 2;
                passValidate = true;
            }
        }
        if (!passValidate) {
            MOut.println("Available command: on,off,reset");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isGigabitPresent(gbIndex)) {
            MOut.println("Gigabit Switch " + gbIndex + " is not present");
            this.statusCode = 151;
            return;
        }
        switch (this.subCommand) {
            case 0: {
                boolean boolResult = this.ipmiCMMOEMCommand.enableGigabitSwitchPower(gbIndex, (byte)1);
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case 1: {
                boolean boolResult = this.ipmiCMMOEMCommand.enableGigabitSwitchPower(gbIndex, (byte)0);
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
                break;
            }
            case 2: {
                boolean boolResult = this.ipmiCMMOEMCommand.resetGigabitSwitch(gbIndex);
                if (boolResult) {
                    MOut.println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.println("Failed");
                this.statusCode = 149;
            }
        }
    }
}

