/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MB_BHQME_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String CPU3_VOLTAGE = "CPU3 Voltage";
    public static final String CPU4_VOLTAGE = "CPU4 Voltage";
    public static final String CPU1_TEMP = "CPU1 Temp.";
    public static final String CPU2_TEMP = "CPU2 Temp.";
    public static final String CPU3_TEMP = "CPU3 Temp.";
    public static final String CPU4_TEMP = "CPU4 Temp.";
    protected byte cpu3CoreVoltage;
    protected byte cpu4CoreVoltage;

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npollCount = 0x" + ByteUtility.byteToHex(this.pollCount));
        sb.append("\nflag = 0x" + ByteUtility.byteToHex(this.flag));
        sb.append("\nremoteCPU1Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU1Temp) + "(" + this.getRemoteCPU1Temp() + ")");
        sb.append("\nremoteCPU2Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU2Temp) + "(" + this.getRemoteCPU2Temp() + ")");
        sb.append("\nremoteCPU3Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU3Temp) + "(" + this.getRemoteCPU3Temp() + ")");
        sb.append("\nremoteCPU4Temp = 0x" + ByteUtility.byteToHex(this.remoteCPU4Temp) + "(" + this.getRemoteCPU4Temp() + ")");
        sb.append("\nsystemTemp = 0x" + ByteUtility.byteToHex(this.systemTemp) + "(" + this.getSystemTemp() + ")");
        sb.append("\ncpu1CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu1CoreVoltage) + "(" + this.getCpu1CoreVoltageFormula() + ")");
        sb.append("\ncpu2CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu2CoreVoltage) + "(" + this.getCpu2CoreVoltageFormula() + ")");
        sb.append("\ncpu3CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu3CoreVoltage) + "(" + this.getCpu3CoreVoltageFormula() + ")");
        sb.append("\ncpu4CoreVoltage = 0x" + ByteUtility.byteToHex(this.cpu4CoreVoltage) + "(" + this.getCpu4CoreVoltageFormula() + ")");
        sb.append("\nv1p2 = 0x" + ByteUtility.byteToHex(this.v1p2) + "(" + this.getV1p2Formula() + ")");
        sb.append("\nv3p3 = 0x" + ByteUtility.byteToHex(this.v3p3) + "(" + this.getV3p3Formula() + ")");
        sb.append("\nv12 = 0x" + ByteUtility.byteToHex(this.v12) + "(" + this.getV12Formula() + ")");
        sb.append("\nv5 = 0x" + ByteUtility.byteToHex(this.v5) + "(" + this.getV5Formula() + ")");
        sb.append("\nv5sb = 0x" + ByteUtility.byteToHex(this.v5sb) + "(" + this.getV5sbFormula() + ")");
        sb.append("\nbatteryVoltage = 0x" + ByteUtility.byteToHex(this.batteryVoltage) + "(" + this.getBatteryVoltageFormula() + ")");
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != 35) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.remoteCPU1Temp = raw[2];
        this.remoteCPU2Temp = raw[3];
        this.remoteCPU3Temp = raw[4];
        this.remoteCPU4Temp = raw[5];
        this.systemTemp = raw[6];
        this.cpu1CoreVoltage = raw[7];
        this.cpu2CoreVoltage = raw[8];
        this.cpu3CoreVoltage = raw[9];
        this.cpu4CoreVoltage = raw[10];
        this.v1p2 = raw[11];
        this.v3p3 = raw[12];
        this.v12 = raw[13];
        this.v5 = raw[14];
        this.v5sb = raw[15];
        this.batteryVoltage = raw[16];
        this.raw = raw;
        return true;
    }

    public void setCpu3CoreVoltage(byte cpu3CoreVoltage) {
        this.cpu3CoreVoltage = cpu3CoreVoltage;
    }

    public void setCpu4CoreVoltage(byte cpu4CoreVoltage) {
        this.cpu4CoreVoltage = cpu4CoreVoltage;
    }

    public byte getCpu3CoreVoltage() {
        return this.cpu3CoreVoltage;
    }

    public byte getCpu4CoreVoltage() {
        return this.cpu4CoreVoltage;
    }

    @Override
    public double getCpu1CoreVoltageHighLimit() {
        return 1.5;
    }

    @Override
    public double getCpu2CoreVoltageHighLimit() {
        return 1.5;
    }

    public double getCpu3CoreVoltageHighLimit() {
        return 1.5;
    }

    public double getCpu3CoreVoltageLowLimit() {
        return 0.92;
    }

    public double getCpu3CoreVoltageFormula() {
        return (double)(this.cpu3CoreVoltage & 0xFF) * 0.016;
    }

    public double getCpu4CoreVoltageHighLimit() {
        return 1.5;
    }

    public double getCpu4CoreVoltageLowLimit() {
        return 0.92;
    }

    public double getCpu4CoreVoltageFormula() {
        return (double)(this.cpu4CoreVoltage & 0xFF) * 0.016;
    }

    public int checkCpu3CoreVoltage() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getCpu3CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu3CoreVoltageFormula() <= this.getCpu3CoreVoltageLowLimit() || this.getCpu3CoreVoltageFormula() >= this.getCpu3CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu4CoreVoltage() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 2;
        }
        if (this.getCpu4CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu4CoreVoltageFormula() <= this.getCpu4CoreVoltageLowLimit() || this.getCpu4CoreVoltageFormula() >= this.getCpu4CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_TEMP));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_TEMP));
        }
        if (this.checkRemoteCPU3Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU3_TEMP));
        }
        if (this.checkRemoteCPU4Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU4_TEMP));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "System Temp."));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Voltage"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Voltage"));
        }
        if (this.checkCpu3CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU3_VOLTAGE));
        }
        if (this.checkCpu4CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU4_VOLTAGE));
        }
        if (this.checkV1p2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.2V"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "Battery"));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), CPU1_TEMP, "" + this.showCandF(this.getRemoteCPU1Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU1TempHighLimit()));
        this.addRaw(this.checkRemoteCPU2Temp(), CPU2_TEMP, "" + this.showCandF(this.getRemoteCPU2Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU2TempHighLimit()));
        this.addRaw(this.checkRemoteCPU3Temp(), CPU3_TEMP, "" + this.showCandF(this.getRemoteCPU3Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU3TempHighLimit()));
        this.addRaw(this.checkRemoteCPU4Temp(), CPU4_TEMP, "" + this.showCandF(this.getRemoteCPU4Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU4TempHighLimit()));
        this.addRaw(this.checkSystemTemp(), "System Temp.", "" + this.showCandF(this.getSystemTemp()), "n/a", "" + this.showCandF(this.getSystemTempHighLimit()));
        if (this.getRemoteCPU1Temp() == 0) {
            this.setCpu1CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU2Temp() == 0) {
            this.setCpu2CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU3Temp() == 0) {
            this.setCpu3CoreVoltage((byte)0);
        }
        if (this.getRemoteCPU4Temp() == 0) {
            this.setCpu4CoreVoltage((byte)0);
        }
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Voltage", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Voltage", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu3CoreVoltage(), CPU3_VOLTAGE, this.d2StrV(this.getCpu3CoreVoltageFormula()), this.d2StrV(this.getCpu3CoreVoltageLowLimit()), this.d2StrV(this.getCpu3CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu4CoreVoltage(), CPU4_VOLTAGE, this.d2StrV(this.getCpu4CoreVoltageFormula()), this.d2StrV(this.getCpu4CoreVoltageLowLimit()), this.d2StrV(this.getCpu4CoreVoltageHighLimit()));
        this.addRaw(this.checkV1p2(), "1.2V", this.d2StrV(this.getV1p2Formula()), this.d2StrV(this.getV1p2LowLimit()), this.d2StrV(this.getV1p2HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), "5VSB", this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5sbLowLimit()), this.d2StrV(this.getV5sbHighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "Battery", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), CPU1_TEMP, "" + this.showCandF(this.getRemoteCPU1Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU1TempHighLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), CPU2_TEMP, "" + this.showCandF(this.getRemoteCPU2Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU2TempHighLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU3Temp(), CPU3_TEMP, "" + this.showCandF(this.getRemoteCPU3Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU3TempHighLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU4Temp(), CPU4_TEMP, "" + this.showCandF(this.getRemoteCPU4Temp()), "n/a", "" + this.showCandF(this.getRemoteCPU4TempHighLimit())));
        list.add(this.createTemperatureData(this.checkSystemTemp(), "System Temp.", "" + this.showCandF(this.getSystemTemp()), "n/a", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }
}

