/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import nn.pp.drvredir.DriveAccess;
import nn.pp.rc.T;

class DrvRedirIso
implements DriveAccess {
    RandomAccessFile file;
    private static final int ISO_SECTOR_SIZE = 2048;
    private static final int FLOPPY_SECTOR_SIZE = 512;
    private int mspType = 0;
    private int sectorSize = 2048;
    private boolean debug = false;
    private static final int TAGLEN = 5;
    private static final int ISO9660_MAGIC_POS = 32769;
    private static final String ISOTAG = "CD001";

    DrvRedirIso() {
    }

    void openFile(String directory, String filename) throws IOException {
        this.file = new RandomAccessFile(new File(directory, filename), "r");
        if (this.file == null) {
            throw new IOException(T._("Could not open file"));
        }
        if (this.isFloppy(this.file)) {
            this.mspType = 1;
            this.sectorSize = 512;
        }
    }

    void closeFile() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file = null;
    }

    boolean isFloppy(RandomAccessFile file) throws IOException {
        long len = file.length();
        if (len > 0x2D0000L || len % 512L != 0L) {
            if (this.debug) {
                System.out.println("Image file is not a floppy image!");
            }
            return false;
        }
        if (this.debug) {
            System.out.println("Image file is floppy image");
        }
        return true;
    }

    boolean isIso(RandomAccessFile file) throws IOException {
        long len = file.length();
        if ((len < 32774L || len % 512L != 0L) && this.debug) {
            System.out.println("Image file is not a ISO image, size doesn't match!");
        }
        byte[] imageTagBytes = new byte[5];
        try {
            long fp = file.getFilePointer();
            file.seek(32769L);
            file.readFully(imageTagBytes, 0, 5);
            file.seek(fp);
        }
        catch (IOException e) {
            return false;
        }
        String imageTag = new String(imageTagBytes);
        if (!ISOTAG.equals(imageTag)) {
            if (this.debug) {
                System.out.println("Image file is not a ISO image, tag doesn't match (" + imageTag + " - " + ISOTAG + ")");
            }
            return false;
        }
        if (this.debug) {
            System.out.println("Image file is ISO image");
        }
        return true;
    }

    public boolean mediumChangeSupported() {
        return false;
    }

    public int getMSPDriveType() {
        return this.mspType;
    }

    public int getSectorSize() {
        return this.sectorSize;
    }

    public int getSectorNo() throws IOException {
        return (int)(this.file.length() / (long)this.sectorSize) - 1;
    }

    public void readCDSectors(long startSector, long noSectors, byte[] dataBuf) throws IOException {
        this.file.seek(startSector * (long)this.sectorSize);
        this.file.readFully(dataBuf, 0, (int)(noSectors * (long)this.sectorSize));
    }

    public void writeCDSectors(long startSector, long noSectors, byte[] dataBuf) throws IOException {
        throw new IOException(T._("Writing not supported"));
    }
}

