/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.VirtualMediaInfo;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import nn.pp.drvredir.AES_CBC_128;
import nn.pp.drvredir.ByteUtility;
import nn.pp.drvredir.DriveRedirectionApplet_jRefreshButton_actionAdapter;
import nn.pp.drvredir.DriveRedirectionApplet_jStopDrive1Button_actionAdapter;
import nn.pp.drvredir.DriveRedirectionApplet_jStopDrive2Button_actionAdapter;
import nn.pp.drvredir.DrvRedirPanel;
import nn.pp.rc.RFBProfile;

public class DriveRedirectionApplet
extends Applet {
    IPMIInterfaceConfig config;
    ISessionController sessionController;
    IPMIRaritanOEMCommand ipmiRaritanOEMCommand;
    IPMIInterface rmcp;
    Timer keepSessionTimer;
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    DrvRedirPanel drvRedirPanel;
    RFBProfile rfbProfile;
    String ip;
    String id;
    String password;
    int enc;
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JButton jRefreshButton = new JButton();
    JButton jStopDrive2Button = new JButton();
    JButton jStopDrive1Button = new JButton();
    TitledBorder titledBorder1 = new TitledBorder("");

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public DriveRedirectionApplet() {
        this.rfbProfile = new RFBProfile();
        this.rfbProfile.driveRedirectionNoDrives = 2;
        this.rfbProfile.driveRedirection = true;
    }

    public void init() {
        System.out.println("Drive Redirection Applet (Build 070829)");
        try {
            this.ip = this.getParameter("ip", "");
            if (this.ip.length() == 0) {
                this.ip = this.getCodeBase().getHost();
                System.out.println("ip = " + this.ip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.id = this.getParameter("id", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.password = this.getParameter("password", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.enc = Integer.parseInt(this.getParameter("enc", "0"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.enc == 1) {
            String decryptedPassword;
            this.rfbProfile.password = decryptedPassword = this.decryptPassword(this.password);
            this.password = decryptedPassword;
        } else {
            this.rfbProfile.password = this.password;
        }
        this.rfbProfile.remoteHost = this.ip;
        this.rfbProfile.username = this.id;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initDriveStatus();
    }

    private void jbInit() throws Exception {
        this.drvRedirPanel = new DrvRedirPanel(this.getCodeBase(), this.rfbProfile);
        this.setLayout(this.borderLayout2);
        this.jRefreshButton.setText("Refresh");
        this.jRefreshButton.addActionListener(new DriveRedirectionApplet_jRefreshButton_actionAdapter(this));
        this.jStopDrive2Button.setText("Stop Drive 2");
        this.jStopDrive2Button.addActionListener(new DriveRedirectionApplet_jStopDrive2Button_actionAdapter(this));
        this.jStopDrive1Button.setText("Stop Drive 1");
        this.jStopDrive1Button.addActionListener(new DriveRedirectionApplet_jStopDrive1Button_actionAdapter(this));
        this.jPanel1.setBorder(null);
        this.add((Component)this.drvRedirPanel, "Center");
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jStopDrive1Button);
        this.jPanel1.add(this.jStopDrive2Button);
        this.jPanel1.add(this.jRefreshButton);
        this.drvRedirPanel.open();
        this.drvRedirPanel.emptyTitledBorder();
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        try {
            System.out.println("call destroy()");
            this.keepSessionTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"id", "String", ""}, {"password", "String", ""}};
        return pinfo;
    }

    public String decryptPassword(String encryptedPassword) {
        AES_CBC_128 aes = new AES_CBC_128();
        byte[] key = new byte[]{83, 85, 80, 69, 82, 77, 73, 67, 82, 79, 1, 2, 3, 4, 5, 6};
        byte[] iv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        byte[] input = ByteUtility.toBinArray(encryptedPassword);
        byte[] decrypted = aes.decrypt(iv, key, input);
        return new String(decrypted).trim();
    }

    public void initDriveStatus() {
        this.config = new IPMIInterfaceConfig();
        this.config.setIp(this.ip);
        this.config.setUserName(this.id);
        this.config.setPassword(this.password);
        this.config.setTimeout(5);
        this.config.setRetry(2);
        this.ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        MessageCenter.getInstance().deleteObservers();
        TimerTask t = new TimerTask(){

            public void run() {
                DriveRedirectionApplet.this.getVirtualMediaStatus();
            }
        };
        this.keepSessionTimer = new Timer();
        this.keepSessionTimer.schedule(t, 0L, 5000L);
    }

    public synchronized void getVirtualMediaStatus() {
        boolean b = this.login();
        if (!b) {
            return;
        }
        VirtualMediaInfo drive1 = this.ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)1);
        if (drive1 == null) {
            return;
        }
        switch (drive1.getDeviceStatus()) {
            case 0: {
                this.jStopDrive1Button.setEnabled(false);
                this.drvRedirPanel.setDriveConnectButtonEnabled(0, true);
                break;
            }
            default: {
                this.jStopDrive1Button.setEnabled(true);
                this.drvRedirPanel.setDriveConnectButtonEnabled(0, false);
            }
        }
        VirtualMediaInfo drive2 = this.ipmiRaritanOEMCommand.getVirtualMediaStatus((byte)2);
        if (drive2 == null) {
            return;
        }
        switch (drive2.getDeviceStatus()) {
            case 0: {
                this.jStopDrive2Button.setEnabled(false);
                this.drvRedirPanel.setDriveConnectButtonEnabled(1, true);
                break;
            }
            default: {
                this.jStopDrive2Button.setEnabled(true);
                this.drvRedirPanel.setDriveConnectButtonEnabled(1, false);
            }
        }
        this.logout();
    }

    public boolean login() {
        this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege((IPMIInterfaceConfig)this.config, (IPMICommand)this.ipmiRaritanOEMCommand);
        if (this.sessionController == null) {
            return false;
        }
        return this.ipmiRaritanOEMCommand.getIPMIInterface() != null;
    }

    public boolean logout() {
        if (this.sessionController != null) {
            return this.sessionController.closeSession();
        }
        return true;
    }

    public void jStopDrive1Button_actionPerformed(ActionEvent e) {
        new Thread(){

            public void run() {
                DriveRedirectionApplet.this.helpStopDrive1();
            }
        }.start();
    }

    private void helpStopDrive1() throws HeadlessException {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure that you want to stop Drive 1 ?", "RequestConfirmation", 0);
        if (result == 0) {
            if (this.login()) {
                this.ipmiRaritanOEMCommand.closeVirtualMediaSession((byte)1);
                this.logout();
            }
            this.getVirtualMediaStatus();
        }
    }

    public void jStopDrive2Button_actionPerformed(ActionEvent e) {
        new Thread(){

            public void run() {
                DriveRedirectionApplet.this.helpStopDrive2();
            }
        }.start();
    }

    private void helpStopDrive2() throws HeadlessException {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure that you want to stop Drive 2 ?", "RequestConfirmation", 0);
        if (result == 0) {
            if (this.login()) {
                this.ipmiRaritanOEMCommand.closeVirtualMediaSession((byte)2);
                this.logout();
            }
            this.getVirtualMediaStatus();
        }
    }

    public void jRefreshButton_actionPerformed(ActionEvent e) {
        this.getVirtualMediaStatus();
    }
}

