/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.Locale;
import nn.pp.rc.ForensicPanel;
import nn.pp.rc.SasEvent;
import nn.pp.rc.SpEvent;
import nn.pp.sara.InfoPanel;
import nn.pp.sara.ReplayPanel;

public class SasForensicPanel
extends ForensicPanel {
    InfoPanel infoPanel;
    ReplayPanel replayPanel;
    Locale locale;
    String defkbd;

    public SasForensicPanel(URL codeBase, String defkbd, Locale locale) {
        super(codeBase);
        this.locale = locale;
        this.defkbd = defkbd;
    }

    public void init(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay) {
        if (showEvents) {
            this.infoPanel = new InfoPanel(this.codeBase, this.locale, this.defkbd, this, localOnly, noKbd);
        }
        if (showReplay) {
            System.out.println("Adding replay panel");
            this.replayPanel = new ReplayPanel(this.codeBase, this);
        } else {
            System.out.println("No replay panel");
        }
        this.addLayout();
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        if (this.infoPanel != null) {
            this.add((Component)this.infoPanel, "North");
        }
        if (this.replayPanel != null) {
            this.add((Component)this.replayPanel, "South");
        }
    }

    public void setEnabled(boolean b) {
        if (this.infoPanel != null) {
            this.infoPanel.setEnabled(b);
        }
        if (this.replayPanel != null) {
            this.replayPanel.setEnabled(b);
        }
    }

    public void handleSasEvent(SasEvent evt) {
        if (this.infoPanel != null) {
            this.infoPanel.handleSasEvent(evt);
        }
    }

    public void handleSpEvent(SpEvent evt) {
        if (this.replayPanel != null) {
            this.replayPanel.handleSpEvent(evt);
        }
    }

    public void newKbdMapping(Locale locale) {
        if (this.infoPanel != null) {
            this.infoPanel.newKbdMapping(locale);
        }
    }

    public void newKbdLayout(String layout) {
        if (this.infoPanel != null) {
            this.infoPanel.newKbdLayout(layout);
        }
    }

    public void show() {
        super.show();
        if (this.infoPanel != null) {
            this.infoPanel.show();
        }
        if (this.replayPanel != null) {
            this.replayPanel.show();
        }
    }

    public void hide() {
        super.hide();
        if (this.infoPanel != null) {
            this.infoPanel.hide();
        }
        if (this.replayPanel != null) {
            this.replayPanel.hide();
        }
    }
}

