/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import nn.pp.rc.SpEvent;
import nn.pp.sara.ButtonsPanel;
import nn.pp.sara.FramePanel;
import nn.pp.sara.SasForensicPanel;
import nn.pp.sara.SliderPanel;
import nn.pp.sara.SpeedPanel;

class ReplayPanel
extends FramePanel {
    private static final int STATE_PLAYING = 0;
    private static final int STATE_PAUSED = 1;
    private static final int STATE_STOPPED = 2;
    int replayState = 2;
    SliderPanel sliderPanel;
    ButtonsPanel buttonsPanel;
    SpeedPanel speedPanel;
    SasForensicPanel forensicPanel;

    public ReplayPanel(URL codeBase, SasForensicPanel parentPanel) {
        super(codeBase, parentPanel);
        this.forensicPanel = parentPanel;
        this.sliderPanel = new SliderPanel(this);
        this.buttonsPanel = new ButtonsPanel(codeBase, this);
        this.speedPanel = new SpeedPanel(this);
        this.addLayout();
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new Panel(new BorderLayout());
        this.mainPanel.add((Component)this.getFrameButtonPanel(), "West");
        Panel p = new Panel(new BorderLayout());
        p.add((Component)this.sliderPanel, "Center");
        Panel p1 = new Panel(new BorderLayout());
        p1.add((Component)this.buttonsPanel, "West");
        p1.add((Component)this.speedPanel, "Center");
        p.add((Component)p1, "South");
        this.mainPanel.add((Component)p, "Center");
        this.showInitial();
    }

    public void setEnabled(boolean b) {
        this.sliderPanel.setEnabled(b);
        this.buttonsPanel.setEnabled(b);
    }

    protected String getFrameName() {
        return "Replay Control";
    }

    private void doPlay() {
        if (this.forensicPanel.rcHandler != null) {
            try {
                this.forensicPanel.rcHandler.sendPlay();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doPause() {
        if (this.forensicPanel.rcHandler != null) {
            try {
                this.forensicPanel.rcHandler.sendPause();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doStop() {
        if (this.forensicPanel.rcHandler != null) {
            try {
                this.forensicPanel.rcHandler.sendStop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doSeek(Date pos) {
        if (this.forensicPanel.rcHandler != null) {
            try {
                this.forensicPanel.rcHandler.sendSeek(pos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void doSetSpeed(int speed) {
        if (this.forensicPanel.rcHandler != null) {
            try {
                this.forensicPanel.rcHandler.sendSpeed(speed);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setReplayTime(Date time) {
        this.sliderPanel.setTime(time);
    }

    private void setReplayTimes(Date time1, Date time2) {
        this.sliderPanel.setReplayTimes(time1, time2);
    }

    private void played() {
        this.replayState = 0;
        this.forensicPanel.rcHandler.setBlank(false);
        this.buttonsPanel.play();
        this.sliderPanel.play();
    }

    private void paused() {
        this.replayState = 1;
        this.buttonsPanel.pause();
        this.sliderPanel.pause();
    }

    private void stopped() {
        this.replayState = 2;
        this.forensicPanel.rcHandler.setBlank(true);
        this.buttonsPanel.stop();
        this.sliderPanel.stop();
    }

    public void handleSpEvent(SpEvent evt) {
        switch (evt.type) {
            case 1: {
                this.setReplayTimes(evt.sessionTimes.start, evt.sessionTimes.end);
                break;
            }
            case 2: {
                this.setReplayTime(evt.replayTime.time);
                break;
            }
            case 3: {
                this.played();
                break;
            }
            case 4: {
                this.paused();
                break;
            }
            case 5: {
                this.stopped();
            }
        }
    }

    void play() {
        if (this.replayState != 0) {
            this.doPlay();
        }
    }

    void pause() {
        if (this.replayState == 0) {
            this.doPause();
        } else if (this.replayState == 1) {
            this.doPlay();
        }
    }

    void stop() {
        if (this.replayState != 2) {
            this.doStop();
        }
    }

    void seek(Date pos) {
        if (this.replayState == 0) {
            this.doSeek(pos);
        }
    }

    void setSpeed(int speed) {
        this.doSetSpeed(speed);
    }
}

