/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rcsoftkbd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import nn.pp.rckbd.KeyDef;
import nn.pp.rcsoftkbd.MapDef;
import nn.pp.rcsoftkbd.SoftKbdImpl;

class Key {
    private SoftKbdImpl parent;
    KeyDef keydef;
    MapDef mapdef;
    private boolean over = false;
    private boolean clicked = false;
    public Short shortnumber;
    public Dimension size;
    public Point pos;
    public Color backgroundcolor = NORMALCOLOR;
    static final Color NORMALCOLOR = new Color(220, 220, 220);
    static final Color OVERCOLOR = new Color(170, 170, 170);
    static final Color PRESSEDCOLOR = new Color(150, 150, 255);

    public Key(SoftKbdImpl parent, KeyDef keydef, MapDef mapdef, Dimension size, Point position) {
        this.parent = parent;
        this.keydef = keydef;
        this.mapdef = mapdef;
        this.size = size;
        this.pos = position;
        this.shortnumber = new Short(keydef.keynr);
    }

    public void changeMapDef(MapDef mapdef) {
        this.mapdef = mapdef;
        this.repaint();
    }

    public void setOver(boolean over) {
        this.over = over;
        this.backgroundcolor = over ? (this.clicked ? PRESSEDCOLOR : OVERCOLOR) : (this.clicked ? PRESSEDCOLOR : NORMALCOLOR);
        this.repaint();
    }

    public void setClicked(boolean clicked) {
        this.clicked = clicked;
        this.backgroundcolor = clicked ? PRESSEDCOLOR : (this.over ? OVERCOLOR : NORMALCOLOR);
        this.repaint();
    }

    public boolean isOver() {
        return this.over;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public boolean contains(Point p) {
        return p.x >= this.pos.x && p.x <= this.pos.x + this.size.width && p.y >= this.pos.y && p.y <= this.pos.y + this.size.height;
    }

    private void repaint() {
        this.parent.repaint(this);
    }
}

