/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import nn.pp.rc.test.DisplayModeModel;

public class DisplayModeTest
extends JFrame
implements ActionListener,
ListSelectionListener {
    private boolean waiting = false;
    private GraphicsDevice device;
    private DisplayMode originalDM;
    private JButton exit = new JButton("Exit");
    private JButton changeDM = new JButton("Set Display");
    private JLabel currentDM = new JLabel();
    private JTable dmList = new JTable();
    private JScrollPane dmPane = new JScrollPane(this.dmList);
    private boolean isFullScreen = false;
    public static final int INDEX_WIDTH = 0;
    public static final int INDEX_HEIGHT = 1;
    public static final int INDEX_BITDEPTH = 2;
    public static final int INDEX_REFRESHRATE = 3;
    public static final int[] COLUMN_WIDTHS = new int[]{100, 100, 100, 100};
    public static final String[] COLUMN_NAMES = new String[]{"Width", "Height", "Bit Depth", "Refresh Rate"};

    public DisplayModeTest(GraphicsDevice device) {
        super(device.getDefaultConfiguration());
        this.device = device;
        this.setTitle("Display Mode Test");
        this.originalDM = device.getDisplayMode();
        this.setDMLabel(this.originalDM);
        this.setDefaultCloseOperation(3);
        this.exit.addActionListener(this);
        this.changeDM.addActionListener(this);
        this.changeDM.setEnabled(device.isDisplayChangeSupported());
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.exit) {
            this.device.setDisplayMode(this.originalDM);
            System.exit(0);
        } else {
            int index = this.dmList.getSelectionModel().getAnchorSelectionIndex();
            if (index >= 0) {
                DisplayModeModel model = (DisplayModeModel)this.dmList.getModel();
                DisplayMode dm = model.getDisplayMode(index);
                this.device.setDisplayMode(dm);
                this.setDMLabel(dm);
                this.setSize(new Dimension(dm.getWidth(), dm.getHeight()));
                this.validate();
            }
        }
    }

    public void valueChanged(ListSelectionEvent ev) {
        this.changeDM.setEnabled(this.device.isDisplayChangeSupported());
    }

    private void initComponents(Container c) {
        this.setContentPane(c);
        c.setLayout(new BorderLayout());
        JPanel currentPanel = new JPanel(new FlowLayout(1));
        c.add((Component)currentPanel, "North");
        JLabel current = new JLabel("Current Display Mode : ");
        currentPanel.add(current);
        currentPanel.add(this.currentDM);
        JPanel modesPanel = new JPanel(new GridLayout(1, 2));
        c.add((Component)modesPanel, "Center");
        for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
            TableColumn col = new TableColumn(i, COLUMN_WIDTHS[i]);
            col.setIdentifier(COLUMN_NAMES[i]);
            col.setHeaderValue(COLUMN_NAMES[i]);
            this.dmList.addColumn(col);
        }
        this.dmList.getSelectionModel().setSelectionMode(0);
        this.dmList.getSelectionModel().addListSelectionListener(this);
        modesPanel.add(this.dmPane);
        JPanel controlsPanelA = new JPanel(new BorderLayout());
        modesPanel.add(controlsPanelA);
        JPanel controlsPanelB = new JPanel(new GridLayout(2, 1));
        controlsPanelA.add((Component)controlsPanelB, "North");
        JPanel exitPanel = new JPanel(new FlowLayout(1));
        controlsPanelB.add(exitPanel);
        exitPanel.add(this.exit);
        JPanel changeDMPanel = new JPanel(new FlowLayout(1));
        controlsPanelB.add(changeDMPanel);
        changeDMPanel.add(this.changeDM);
        controlsPanelA.add((Component)new JPanel(), "Center");
    }

    public void setVisible(boolean isVis) {
        super.setVisible(isVis);
        if (isVis) {
            this.dmList.setModel(new DisplayModeModel(this.device.getDisplayModes()));
        }
    }

    public void setDMLabel(DisplayMode newMode) {
        int bitDepth = newMode.getBitDepth();
        int refreshRate = newMode.getRefreshRate();
        String bd = bitDepth == -1 ? "Multi" : Integer.toString(bitDepth);
        String rr = refreshRate == 0 ? "Unknown" : Integer.toString(refreshRate);
        this.currentDM.setText(COLUMN_NAMES[0] + ": " + newMode.getWidth() + " " + COLUMN_NAMES[1] + ": " + newMode.getHeight() + " " + COLUMN_NAMES[2] + ": " + bd + " " + COLUMN_NAMES[3] + ": " + rr);
    }

    public void begin() {
        this.isFullScreen = this.device.isFullScreenSupported();
        this.setUndecorated(this.isFullScreen);
        this.setResizable(!this.isFullScreen);
        if (this.isFullScreen) {
            this.device.setFullScreenWindow(this);
            this.validate();
        } else {
            this.pack();
            this.setVisible(true);
        }
    }

    public static void main(String[] args) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (int i = 0; i < 1; ++i) {
            DisplayModeTest test = new DisplayModeTest(devices[i]);
            test.initComponents(test.getContentPane());
            test.begin();
        }
    }
}

