/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import nn.pp.rc.CloseablePanel;
import nn.pp.rc.DriveRedirectionContainer;
import nn.pp.rc.ForensicPanel;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rc.TimerQueue;

public class ServerConsoleFrame
extends Frame
implements DriveRedirectionContainer {
    private ServerConsolePanelBase panel;
    private CloseablePanel drvRedirPanel;
    private URL onCloseURL = null;
    private String onCloseURLTarget = null;
    private AppletContext appletContext = null;
    private URL codeBase;
    private ClassLoader classLoader;
    private RFBProfile profile;
    public String title;
    private ForensicPanel forensicPanel;
    static /* synthetic */ Class class$java$net$URL;

    public ServerConsoleFrame(URL codeBase, AppletContext appletContext, ClassLoader classLoader, RFBProfile profile, String title, String cluster_port_id, ServerConsolePanelBase panel) {
        super(title + " " + T._("Remote Console") + (cluster_port_id.equals("") ? "" : " (" + T._("Port") + " " + cluster_port_id + ")"));
        this.title = title;
        this.panel = panel;
        this.codeBase = codeBase;
        this.classLoader = classLoader;
        this.profile = profile;
        this.appletContext = appletContext;
        this.enableEvents(207L);
        this.add((Component)panel, "Center");
        if (profile.driveRedirection) {
            this.drvRedirPanel = this.loadDrvRedirPanel(classLoader, codeBase, profile);
            if (this.drvRedirPanel != null) {
                panel.setDrvRedirPanel(this.drvRedirPanel);
            } else {
                System.out.println("Could not load Drive Redirection classes.");
                panel.hideDrvRedirButton();
            }
        }
    }

    public void showDriveRedirection(boolean show) {
        if (this.drvRedirPanel == null) {
            return;
        }
        if (show) {
            this.add((Component)this.drvRedirPanel, "South");
            this.drvRedirPanel.open(this);
        } else {
            this.remove(this.drvRedirPanel);
        }
        this.pack();
    }

    public void showThumbnailPane(boolean show, Panel panel) {
        if (show) {
            this.add((Component)panel, "East");
        } else {
            this.remove(panel);
        }
        this.pack();
    }

    void showForensic(boolean show) {
        if (this.forensicPanel == null) {
            return;
        }
        if (show) {
            this.add((Component)this.forensicPanel, "South");
            this.forensicPanel.show();
        } else {
            this.remove(this.forensicPanel);
            this.forensicPanel.hide();
        }
        this.pack();
    }

    public void close() {
        this.setVisible(true);
        Class fclass = Frame.class;
        Class[] params = new Class[1];
        Object[] arglist = new Object[1];
        params[0] = Integer.TYPE;
        arglist[0] = new Integer(0);
        try {
            Method me = fclass.getMethod("setState", params);
            me.invoke((Object)this, arglist);
        }
        catch (Exception e) {
            System.out.println("setState failed: " + e.getMessage());
        }
        this.dispose();
        this.panel.close();
        if (this.drvRedirPanel != null) {
            this.drvRedirPanel.close();
        }
        if (this.forensicPanel != null) {
            this.forensicPanel.hide();
        }
        TimerQueue.cleanUp();
    }

    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.close();
            if (this.onCloseURL != null && this.appletContext != null) {
                if (this.onCloseURLTarget != null) {
                    this.appletContext.showDocument(this.onCloseURL, this.onCloseURLTarget);
                } else {
                    this.appletContext.showDocument(this.onCloseURL);
                }
            }
        } else if (event.getID() == 203 || event.getID() == 204) {
            // empty if block
        }
    }

    public void setOnCloseURL(String url, String target) {
        if (this.codeBase != null) {
            try {
                this.onCloseURL = new URL(this.codeBase, url);
                this.onCloseURLTarget = target;
            }
            catch (MalformedURLException e) {
                this.panel.logger.println(T._("Console: OnCloseURL:") + " " + e);
            }
        }
    }

    private CloseablePanel loadDrvRedirPanel(ClassLoader classLoader, URL codeBase, RFBProfile profile) {
        CloseablePanel ret = null;
        if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
            J14DrvRedirStaticLoader l = new J14DrvRedirStaticLoader();
            return l.loadDrvRedirPanel(classLoader, codeBase, profile);
        }
        return ret;
    }

    ForensicPanel addForensicPanel(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay) {
        if (this.forensicPanel == null) {
            J14ForensicStaticLoader l = new J14ForensicStaticLoader();
            this.forensicPanel = l.loadSasPanel(this.classLoader, this.codeBase);
        }
        if (this.forensicPanel != null) {
            this.forensicPanel.init(showEvents, localOnly, noKbd, showReplay);
        }
        return this.forensicPanel;
    }

    class J14ForensicStaticLoader {
        J14ForensicStaticLoader() {
        }

        public ForensicPanel loadSasPanel(ClassLoader classLoader, URL codeBase) {
            ForensicPanel p = null;
            try {
                Class<?> cl = Class.forName("nn.pp.sara.SasForensicPanel", false, classLoader);
                Class[] classArray = new Class[3];
                classArray[0] = class$java$net$URL == null ? (class$java$net$URL = ServerConsoleFrame.class$("java.net.URL")) : class$java$net$URL;
                ServerConsoleFrame.this.panel;
                classArray[1] = ServerConsolePanelBase.defkbd.getClass();
                classArray[2] = ServerConsoleFrame.this.panel.getCurMapping().getClass();
                Class[] cstrtypes = classArray;
                Constructor<?> sasConstructor = cl.getConstructor(cstrtypes);
                Object[] objectArray = new Object[3];
                objectArray[0] = codeBase;
                ServerConsoleFrame.this.panel;
                objectArray[1] = ServerConsolePanelBase.defkbd;
                objectArray[2] = ServerConsoleFrame.this.panel.getCurMapping();
                Object[] arglist = objectArray;
                p = (ForensicPanel)sasConstructor.newInstance(arglist);
            }
            catch (Exception e) {
                System.out.println("loadSasPanel: " + e);
                e.printStackTrace();
            }
            return p;
        }
    }

    class J14DrvRedirStaticLoader {
        J14DrvRedirStaticLoader() {
        }

        public CloseablePanel loadDrvRedirPanel(ClassLoader classLoader, URL codeBase, RFBProfile prof) {
            CloseablePanel p = null;
            try {
                Class<?> cl = Class.forName("nn.pp.drvredir.DrvRedirPanel", false, classLoader);
                Class[] cstrtypes = new Class[]{class$java$net$URL == null ? (class$java$net$URL = ServerConsoleFrame.class$("java.net.URL")) : class$java$net$URL, prof.getClass()};
                Constructor<?> drvRedirConstructor = cl.getConstructor(cstrtypes);
                Object[] arglist = new Object[]{codeBase, prof};
                p = (CloseablePanel)drvRedirConstructor.newInstance(arglist);
            }
            catch (Exception e) {
                System.out.println("loadDrvRedirPanel: " + e);
                e.printStackTrace();
            }
            return p;
        }
    }
}

