/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import com.supermicro.ipmi.MessageCenter;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Panel;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import nn.pp.rc.ParameterReader;
import nn.pp.rc.RemoteConsoleLoader;
import nn.pp.rc.T;

public class RemoteConsoleApplication
implements ParameterReader {
    GraphicsDevice graphicsDevice;
    DisplayMode orgdm;
    private String[] params;
    private RemoteConsoleLoader loader;

    public void parameterError(String s) throws Exception {
        throw new Exception(s);
    }

    public String getRemoteHost() throws Exception {
        return this.readParameter("HOST", true);
    }

    public String readParameter(String reqName, boolean required) throws Exception {
        reqName = reqName.toUpperCase();
        String ret = null;
        for (int i = 0; i < this.params.length; ++i) {
            String name = this.params[i].toUpperCase();
            if (!name.startsWith("/" + reqName) && !name.startsWith("-" + reqName)) continue;
            if (i + 1 >= this.params.length) break;
            ret = this.params[i + 1];
            break;
        }
        if (ret == null && required) {
            this.parameterError(MessageFormat.format(T._("Required parameter \"{0}\" not found"), reqName));
        }
        return ret;
    }

    public String[] readArrayParameter(String basename) throws Exception {
        String s;
        int index = 0;
        while (null != (s = this.readParameter(basename + index, false))) {
            ++index;
        }
        String[] hotkeys = new String[index];
        for (int i = 0; i < index; ++i) {
            hotkeys[i] = s = this.readParameter(basename + i, false);
        }
        return hotkeys;
    }

    public RemoteConsoleApplication(String[] params) {
        this.params = params;
    }

    public Panel getRemoteConsole() {
        this.loader = new RemoteConsoleLoader(this, null);
        return this.loader;
    }

    public void runRemoteConsole(boolean inFrame, boolean start) throws Exception {
        this.loader.init(inFrame, null, null, start);
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        if (args.length < 3) {
            System.exit(0);
        }
        String ip = args[0];
        String username = args[1];
        String password = args[2];
        if (!RemoteConsoleApplication.validateIP(ip)) {
            System.out.println("IP format erorr !");
            System.exit(1);
        }
        String[] p = new String[]{"/host", ip, "/port", "443", "/username", username, "/password", password, "/protocol_version", "01.16", "/DRIVE_REDIRECTION", "no", "/HOTKEY_0", "confirm Ctrl+Alt+Del", "/HOTKEYCODE_0", "36 f0 37 f0 4e", "/HOTKEYNAME_0", "", "/VS_PERM_STD", "yes", "/VS_PERM_ADV", "yes", "/SelEnc", "preconf", "/FixEnc", "lanhi", "/HWENC", "yes", "/MOUSESYNC_KEY", "Alt+F12", "/MOUSESYNC_KEYCODE", "37 47", "/USE_IIP", "yes"};
        RemoteConsoleApplication app = new RemoteConsoleApplication(p);
        app.setLookAndFeel();
        Panel remoteConsolePanel = app.getRemoteConsole();
        try {
            app.runRemoteConsole(true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIManager.put("InternalFrame.titleFont", new Font("Serif", 1, 12));
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }
}

