/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ASFMessage;
import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.RMCPHeader;
import com.supermicro.ipmi.RMCPSession;
import com.supermicro.ipmi.SOLMessage;
import com.supermicro.ipmi.UDPSocket;
import java.net.UnknownHostException;
import java.util.Observable;

public class RMCP
extends IPMINetworkInterface {
    UDPSocket udpSocket;
    RMCPHeader rmcpHeader = new RMCPHeader();
    RMCPSession rmcpSession = new RMCPSession();
    IPMIInterfaceConfig config;
    SOLMessage lastSOLMessage;

    public void initialize(IPMIInterfaceConfig config) {
        this.config = config;
        try {
            this.udpSocket = new UDPSocket(config.getIp(), config.getPort(), config.getTimeout(), config.getRetry());
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        ProxyConfig proxyConfig = config.getProxyConfig();
        if (proxyConfig != null && proxyConfig.isProxyEnabled) {
            this.udpSocket.setProxyConfig(proxyConfig);
            proxyConfig.startProxy(this.udpSocket, config);
        }
    }

    public void stopProxy() {
        ProxyConfig proxyConfig = this.config.getProxyConfig();
        if (proxyConfig != null && proxyConfig.isProxyEnabled) {
            proxyConfig.stopProxy(this.udpSocket);
        }
    }

    public synchronized void drop(IIPMIMessage ipmiMessage) {
        if (this.rmcpSession.authType != 0) {
            this.rmcpSession.calcAuthCode(ipmiMessage, this.config.getPassword());
        }
        if (ipmiMessage instanceof SOLMessage) {
            this.rmcpSession.setAuthType((byte)-126);
        } else if (ipmiMessage instanceof IPMIMessage && this.rmcpSession.authType != 0) {
            this.rmcpSession.setAuthType((byte)2);
        }
        byte[] head = this.rmcpHeader.raw();
        byte[] session = this.rmcpSession.raw();
        byte[] message = ipmiMessage.raw();
        byte[] data = new byte[head.length + session.length + 1 + message.length];
        System.arraycopy(head, 0, data, 0, head.length);
        System.arraycopy(session, 0, data, head.length, session.length);
        data[head.length + session.length] = (byte)message.length;
        System.arraycopy(message, 0, data, head.length + session.length + 1, message.length);
        this.udpSocket.dropPacket(data);
        if (this.rmcpSession.authType != 0) {
            this.rmcpSession.IncreaseSessionSeq();
        }
    }

    public synchronized IPMIMessage send(IIPMIMessage ipmiMessage) {
        if (this.rmcpSession.authType != 0) {
            this.rmcpSession.calcAuthCode(ipmiMessage, this.config.getPassword());
        }
        if (ipmiMessage instanceof SOLMessage) {
            this.rmcpSession.setAuthType((byte)-126);
        } else if (ipmiMessage instanceof IPMIMessage && this.rmcpSession.authType != 0) {
            this.rmcpSession.setAuthType((byte)2);
        }
        byte[] head = this.rmcpHeader.raw();
        byte[] session = this.rmcpSession.raw();
        byte[] message = ipmiMessage.raw();
        byte[] data = new byte[head.length + session.length + 1 + message.length];
        System.arraycopy(head, 0, data, 0, head.length);
        System.arraycopy(session, 0, data, head.length, session.length);
        data[head.length + session.length] = (byte)message.length;
        System.arraycopy(message, 0, data, head.length + session.length + 1, message.length);
        byte[] result = null;
        if (!this.udpSocket.sendPacket(data)) {
            return null;
        }
        result = this.udpSocket.result;
        byte ipmiMessageLength = this.rmcpSession.authType != 0 ? result[29] : result[13];
        int ipmiRawMessageIndex = this.rmcpSession.authType != 0 ? 30 : 14;
        byte[] ipmiRawMessage = new byte[ipmiMessageLength];
        System.arraycopy(result, ipmiRawMessageIndex, ipmiRawMessage, 0, ipmiMessageLength);
        if (this.rmcpSession.authType != 0) {
            this.rmcpSession.IncreaseSessionSeq();
        }
        return IPMIMessage.fromRaw(ipmiRawMessage);
    }

    public IPMIMessage receive() {
        return null;
    }

    public ASFMessage sendASFMessage(ASFMessage asfMessage) {
        RMCPHeader asfRMCPHeader = new RMCPHeader();
        asfRMCPHeader.classOfMesg = (byte)6;
        byte[] head = asfRMCPHeader.raw();
        byte[] message = asfMessage.raw();
        byte[] data = new byte[head.length + message.length];
        System.arraycopy(head, 0, data, 0, head.length);
        System.arraycopy(message, 0, data, head.length, message.length);
        byte[] result = null;
        if (!this.udpSocket.sendPacket(data)) {
            return null;
        }
        result = this.udpSocket.result;
        byte[] asfRawMessage = new byte[24];
        System.arraycopy(result, 4, asfRawMessage, 0, 24);
        return ASFMessage.fromRaw(asfRawMessage);
    }

    public void startListen() {
        this.udpSocket.startListen();
        this.udpSocket.addObserver(this);
    }

    public void stopListen() {
        this.udpSocket.stopListen();
    }

    public void update(Observable o, Object arg) {
        byte[] result = (byte[])arg;
        byte payLoadType = result[4];
        if ((byte)(payLoadType & 0x80) != -128) {
            return;
        }
        byte[] payload = new byte[result.length - 14];
        byte payloadLength = result[13];
        System.arraycopy(result, 14, payload, 0, payloadLength);
        SOLMessage solMessage = SOLMessage.fromRaw(payload);
        if (solMessage.getPacketSequenceNumber() == 0) {
            this.setChanged();
            this.notifyObservers(new Byte(solMessage.getPacketACKandNACKSequenceNumber()));
            return;
        }
        if (solMessage.getPacketSequenceNumber() != 0) {
            SOLMessage solReplyMessage = new SOLMessage();
            solReplyMessage.setPacketSequenceNumber((byte)0);
            solReplyMessage.setPacketACKandNACKSequenceNumber(solMessage.getPacketSequenceNumber());
            solReplyMessage.setCharacterCount((byte)solMessage.getData().length);
            solReplyMessage.setOperation((byte)0);
            this.drop(solReplyMessage);
        }
        if (this.lastSOLMessage != null && solMessage.getPacketSequenceNumber() == this.lastSOLMessage.getPacketSequenceNumber()) {
            System.out.println("$$$$ repeat packet from Server, seq =" + solMessage.getPacketSequenceNumber());
            byte[] appendedScreenData = new byte[solMessage.getData().length - this.lastSOLMessage.getData().length];
            System.arraycopy(solMessage.data, this.lastSOLMessage.data.length, appendedScreenData, 0, appendedScreenData.length);
            byte[] orgScreenData = solMessage.getData();
            solMessage.setData(appendedScreenData);
            this.setChanged();
            this.notifyObservers(solMessage.getData());
            solMessage.setData(orgScreenData);
            this.lastSOLMessage = solMessage;
            return;
        }
        this.setChanged();
        this.notifyObservers(solMessage.getData());
        this.lastSOLMessage = solMessage;
    }

    public void closeSocket() {
        this.udpSocket.closeSocket();
    }

    public static void main(String[] args) {
        RMCP rmcp = new RMCP();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.245");
        rmcp.initialize(config);
        ASFMessage asfPingMessage = new ASFMessage();
        ASFMessage asfPongMessage = rmcp.sendASFMessage(asfPingMessage);
        if (asfPongMessage != null) {
            System.out.println("successfully ping");
            System.out.println(asfPongMessage.toString());
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 4};
        ipmiMessage.setCommandAndData((byte)24, (byte)56, data);
        rmcp.rmcpSession.authType = 0;
        IPMIMessage responseMsg = rmcp.send(ipmiMessage);
        if (responseMsg != null) {
            System.out.println(responseMsg.toString());
        }
        data = new byte[18];
        data[0] = 2;
        String userName = "ADMIN";
        System.arraycopy(userName.getBytes(), 0, data, 1, userName.length());
        ipmiMessage.setCommandAndData((byte)24, (byte)57, data);
        rmcp.rmcpSession.authType = 0;
        responseMsg = rmcp.send(ipmiMessage);
        if (responseMsg != null) {
            System.out.println(responseMsg.toString());
        }
    }
}

