/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Comparator;
import jcurses.util.Rectangle;
import jcurses.widgets.Widget;

class WindowWidgetComparator
implements Comparator {
    WindowWidgetComparator() {
    }

    static boolean toTheLeftOf(Widget widget1, Widget widget2) {
        Rectangle rect1 = widget1.getRectangle();
        Rectangle rect2 = widget2.getRectangle();
        boolean result = rect1.getX() + rect1.getWidth() - 1 < rect2.getX();
        return result;
    }

    static boolean toTheRightOf(Widget widget1, Widget widget2) {
        Rectangle rect1 = widget1.getRectangle();
        Rectangle rect2 = widget2.getRectangle();
        boolean result = rect1.getX() > rect2.getX() + rect2.getWidth() - 1;
        return result;
    }

    static boolean atTheTopOf(Widget widget1, Widget widget2) {
        Rectangle rect1 = widget1.getRectangle();
        Rectangle rect2 = widget2.getRectangle();
        boolean result = rect1.getY() + rect1.getHeight() - 1 < rect2.getY();
        return result;
    }

    static boolean atTheBottomOf(Widget widget1, Widget widget2) {
        Rectangle rect1 = widget1.getRectangle();
        Rectangle rect2 = widget2.getRectangle();
        boolean result = rect1.getY() > rect2.getY() + rect2.getHeight() - 1;
        return result;
    }

    static int getDistance(Widget widget1, Widget widget2) {
        Rectangle rect1 = widget1.getRectangle();
        Rectangle rect2 = widget2.getRectangle();
        int x1 = rect1.getX() + rect1.getWidth() / 2;
        int y1 = rect1.getY() + rect1.getHeight() / 2;
        int x2 = rect2.getX() + rect2.getWidth() / 2;
        int y2 = rect2.getY() + rect2.getHeight() / 2;
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public int compare(Object obj1, Object obj2) {
        if (!(obj1 instanceof Widget) || !(obj2 instanceof Widget)) {
            throw new RuntimeException("unknown classes to compare");
        }
        Widget widget1 = (Widget)obj1;
        Widget widget2 = (Widget)obj2;
        int result = 0;
        result = WindowWidgetComparator.atTheTopOf(widget1, widget2) ? -1 : (WindowWidgetComparator.atTheBottomOf(widget1, widget2) ? 1 : (WindowWidgetComparator.toTheLeftOf(widget1, widget2) ? -1 : (WindowWidgetComparator.toTheRightOf(widget1, widget2) ? 1 : 0)));
        return result;
    }
}

