/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.widgets.WindowManager;
import jcurses.widgets.WindowManagerBlockingCondition;

class WindowManagerInputThread
extends Thread {
    private boolean _run = true;
    private boolean _read = true;

    WindowManagerInputThread() {
    }

    public void run() {
        while (this.isRunning()) {
            if (!this.isReading()) continue;
            InputChar inputChar = Toolkit.readCharacter();
            WindowManager.handleInput(inputChar);
        }
    }

    protected void block(WindowManagerBlockingCondition cond) {
        Toolkit.endPainting();
        while (cond.evaluate() && this.isRunning()) {
            if (!this.isReading()) continue;
            InputChar inputChar = Toolkit.readCharacter();
            WindowManager.handleInput(inputChar);
        }
    }

    protected synchronized void end() {
        this._run = false;
    }

    protected synchronized void deactivate() {
        this._read = false;
    }

    protected synchronized boolean isRunning() {
        return this._run;
    }

    protected synchronized boolean isReading() {
        return this._read;
    }
}

