/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import jcurses.event.WindowEvent;
import jcurses.event.WindowListener;
import jcurses.event.WindowListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.Panel;
import jcurses.widgets.Widget;
import jcurses.widgets.WindowManager;
import jcurses.widgets.WindowWidgetComparator;

public class Window {
    private Panel _root = null;
    private Vector _focusableChilds = null;
    private int _currentIndex = -1;
    private boolean _visible = false;
    private Rectangle _rect = null;
    private boolean _border = false;
    private String _title = null;
    private boolean _hasShadow = true;
    private Vector _shortCutsList = new Vector();
    private Hashtable _shortCutsTable = new Hashtable();
    boolean _closed = false;
    private static InputChar __defaultClosingChar = new InputChar(27);
    private InputChar _closingChar = this.getDefaultClosingChar();
    private static InputChar __defaultFocusChangeChar = new InputChar('\t');
    private InputChar _focusChangeChar = this.getDefaultFocusChangeChar();
    private static InputChar __upChar = new InputChar(InputChar.KEY_UP);
    private static InputChar __downChar = new InputChar(InputChar.KEY_DOWN);
    private static InputChar __leftChar = new InputChar(InputChar.KEY_LEFT);
    private static InputChar __rightChar = new InputChar(InputChar.KEY_RIGHT);
    private static CharColor __defaultBorderColors = new CharColor(7, 0);
    private CharColor _borderColors = this.getDefaultBorderColors();
    private static CharColor __defaultTitleColors = new CharColor(7, 1);
    private CharColor _titleColors = this.getDefaultTitleColors();
    private static CharColor __shadowColors = new CharColor(0, 0);
    private WindowListenerManager _listenerManager = new WindowListenerManager();

    public Window(int x, int y, int width, int height, boolean border, String title) {
        this._border = border;
        this._title = title;
        this._rect = new Rectangle(width, height);
        this._rect.setLocation(x, y);
        int x1 = border ? x + 1 : x;
        int y1 = border ? y + 1 : y;
        int w = border ? width - 2 : width;
        int h = border ? height - 2 : height;
        this._root = new Panel(w, h);
        this._root.setSize(new Rectangle(w, h));
        this._root.setX(x1);
        this._root.setY(y1);
        this._root.setWindow(this);
        WindowManager.createWindow(this);
    }

    public Window(int width, int height, boolean border, String title) {
        this((Toolkit.getScreenWidth() - width) / 2, (Toolkit.getScreenHeight() - height) / 2, width, height, border, title);
    }

    private void configureRootPanel() {
        if (this._root == null) {
            this._root = new Panel();
        }
        int x = this._rect.getX();
        int y = this._rect.getY();
        int width = this._rect.getWidth();
        int height = this._rect.getHeight();
        int x1 = this._border ? x + 1 : x;
        int y1 = this._border ? y + 1 : y;
        int w = this._border ? width - 2 : width;
        int h = this._border ? height - 2 : height;
        this._root.setSize(new Rectangle(w, h));
        this._root.setX(x1);
        this._root.setY(y1);
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setVisible(boolean value) {
        Window oldTop = WindowManager.getTopWindow();
        if (value) {
            this.pack();
            this._visible = value;
            WindowManager.makeWindowVisible(this, oldTop);
        } else {
            this._visible = value;
            WindowManager.makeWindowInvisible(this, oldTop);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    protected void paint() {
        this.drawThingsIfNeeded();
        this._root.paint();
    }

    protected void repaint() {
        this.drawThingsIfNeeded();
        this._root.repaint();
    }

    protected Rectangle getRectangle() {
        return this._rect;
    }

    public void close() {
        WindowManager.removeWindow(this);
    }

    public void moveToTheTop() {
        WindowManager.moveToTop(this);
    }

    private InputChar getDefaultClosingChar() {
        return __defaultClosingChar;
    }

    public InputChar getClosingChar() {
        return this._closingChar;
    }

    public void setClosingChar(InputChar character) {
        this._closingChar = character;
    }

    private InputChar getDefaultFocusChangeChar() {
        return __defaultFocusChangeChar;
    }

    public InputChar getFocusChangeChar() {
        return this._focusChangeChar;
    }

    public void setFocusChangeChar(InputChar character) {
        this._focusChangeChar = character;
    }

    private boolean isShortCut(InputChar inp) {
        return this._shortCutsList.indexOf(inp) != -1;
    }

    private Widget getWidgetByShortCut(InputChar inp) {
        return (Widget)this._shortCutsTable.get(inp);
    }

    public boolean tryToClose() {
        if (this._listenerManager.countListeners() > 0) {
            this._listenerManager.handleEvent(new WindowEvent(this, 1));
            return this.isClosed();
        }
        this.close();
        return true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected void handleInput(InputChar inp) {
        if (inp.equals(this.getClosingChar())) {
            this.tryToClose();
        } else if (inp.equals(this.getFocusChangeChar())) {
            this.changeFocus();
        } else if (inp.equals(__upChar)) {
            boolean result;
            Widget cur = this.getCurrentWidget();
            if (cur != null && !(result = cur.handleInput(inp))) {
                this.changeFocus(2);
            }
        } else if (inp.equals(__downChar)) {
            boolean result;
            Widget cur = this.getCurrentWidget();
            if (cur != null && !(result = cur.handleInput(inp))) {
                this.changeFocus(3);
            }
        } else if (inp.equals(__leftChar)) {
            boolean result;
            Widget cur = this.getCurrentWidget();
            if (cur != null && !(result = cur.handleInput(inp))) {
                this.changeFocus(0);
            }
        } else if (inp.equals(__rightChar)) {
            boolean result;
            Widget cur = this.getCurrentWidget();
            if (cur != null && !(result = cur.handleInput(inp))) {
                this.changeFocus(1);
            }
        } else if (this.isShortCut(inp)) {
            boolean result;
            Widget cur = this.getCurrentWidget();
            if (cur != null && !(result = cur.handleInput(inp))) {
                this.getWidgetByShortCut(inp).handleInput(inp);
            }
        } else if (!this.handleInputByCurrentChild(inp)) {
            this.onChar(inp);
        }
    }

    protected void onChar(InputChar inp) {
    }

    private void changeFocus() {
        if (this._currentIndex != -1) {
            int newIndex;
            int n = newIndex = this._currentIndex == this._focusableChilds.size() - 1 ? 0 : this._currentIndex + 1;
            if (newIndex != this._currentIndex) {
                ((Widget)this._focusableChilds.elementAt(this._currentIndex)).setFocus(false);
                ((Widget)this._focusableChilds.elementAt(newIndex)).setFocus(true);
                this._currentIndex = newIndex;
            }
        }
    }

    private void changeFocus(int direction) {
        if (this._currentIndex != -1) {
            this.changeFocus(this.getNextWidget(direction));
        }
    }

    private Widget getNextWidget(int direction) {
        Widget result = this.getCurrentWidget();
        Widget current = this.getCurrentWidget();
        int x = result.getAbsoluteX();
        int y = result.getAbsoluteY();
        int searchDirection = direction == 0 || direction == 2 ? -1 : 1;
        Vector widgets = this._focusableChilds;
        int index = widgets.indexOf(result);
        if (index < 0) {
            throw new RuntimeException("widget in the sorted queue not found!!");
        }
        int distance = Integer.MAX_VALUE;
        while (index < widgets.size() && index > -1) {
            int newDistance;
            if ((index += searchDirection) >= widgets.size() || index <= -1) continue;
            Widget candidate = (Widget)widgets.get(index);
            if (!(direction == 0 && WindowWidgetComparator.toTheLeftOf(candidate, current) || direction == 1 && WindowWidgetComparator.toTheRightOf(candidate, current) || direction == 2 && WindowWidgetComparator.atTheTopOf(candidate, current)) && (direction != 3 || !WindowWidgetComparator.atTheBottomOf(candidate, current)) || (newDistance = WindowWidgetComparator.getDistance(candidate, current)) >= distance) continue;
            distance = newDistance;
            result = candidate;
        }
        return result;
    }

    void changeFocus(Widget widget) {
        int newIndex = this._focusableChilds.indexOf(widget);
        if (newIndex != -1) {
            if (this._currentIndex == -1) {
                widget.setFocus(true);
                this._currentIndex = newIndex;
            } else if (this._currentIndex != newIndex) {
                widget.setFocus(true);
                ((Widget)this._focusableChilds.elementAt(this._currentIndex)).setFocus(false);
                this._currentIndex = newIndex;
            }
        }
    }

    private Widget getCurrentWidget() {
        if (this._currentIndex != -1) {
            return (Widget)this._focusableChilds.elementAt(this._currentIndex);
        }
        return null;
    }

    private boolean handleInputByCurrentChild(InputChar inp) {
        if (this._currentIndex != -1) {
            return ((Widget)this._focusableChilds.elementAt(this._currentIndex)).handleInput(inp);
        }
        return false;
    }

    private void loadShortcuts() {
        this._shortCutsList.clear();
        this._shortCutsTable.clear();
        Vector list = this._root.getListOfWidgetsWithShortCuts();
        for (int i = 0; i < list.size(); ++i) {
            Widget widget = (Widget)list.elementAt(i);
            Vector shortCuts = widget.getShortCutsList();
            this._shortCutsList.addAll(shortCuts);
            for (int j = 0; j < shortCuts.size(); ++j) {
                this._shortCutsTable.put(shortCuts.elementAt(j), widget);
            }
        }
    }

    private void loadFocusableChilds() {
        this._focusableChilds = this._root.getListOfFocusables();
        if (this._focusableChilds.size() == 0) {
            this._currentIndex = -1;
        } else {
            Collections.sort(this._focusableChilds, new WindowWidgetComparator());
            this._currentIndex = 0;
            ((Widget)this._focusableChilds.elementAt(0)).setFocus(true);
        }
    }

    public void pack() {
        this.cutIfNeeded();
        this.configureRootPanel();
        this._root.pack();
        this.loadFocusableChilds();
        this.loadShortcuts();
    }

    private void cutIfNeeded() {
        int maxWidth = Toolkit.getScreenWidth() - this._rect.getX() - (this._hasShadow ? 1 : 0);
        int maxHeight = Toolkit.getScreenHeight() - this._rect.getY() - (this._hasShadow ? 1 : 0);
        if (this._rect.getWidth() > maxWidth) {
            this._rect.setWidth(maxWidth);
        }
        if (this._rect.getHeight() > maxHeight) {
            this._rect.setHeight(maxHeight);
        }
    }

    public Panel getRootPanel() {
        return this._root;
    }

    public void setRootPanel(Panel root) {
        this._root = root;
        this._root.setWindow(this);
    }

    private void drawThingsIfNeeded() {
        if (this._border) {
            Toolkit.drawBorder(this._rect, this.getBorderColors());
        }
        this.paintTitle();
        if (this.hasShadow()) {
            Toolkit.drawRectangle(this._rect.getX() + this._rect.getWidth(), this._rect.getY() + 1, 1, this._rect.getHeight(), this.getShadowColors());
            Toolkit.drawRectangle(this._rect.getX() + 1, this._rect.getY() + this._rect.getHeight(), this._rect.getWidth(), 1, this.getShadowColors());
        }
    }

    private void paintTitle() {
        if (this._title != null) {
            CharColor color = this.getTitleColors();
            Toolkit.printString(this._title, this._rect.getX() + (this._rect.getWidth() - this._title.length()) / 2, this._rect.getY(), color);
        }
    }

    public CharColor getDefaultBorderColors() {
        return __defaultBorderColors;
    }

    public CharColor getBorderColors() {
        return this._borderColors;
    }

    public void setBorderColors(CharColor colors) {
        this._borderColors = colors;
    }

    public CharColor getDefaultTitleColors() {
        return __defaultTitleColors;
    }

    public CharColor getTitleColors() {
        return this._titleColors;
    }

    public void setTitleColors(CharColor colors) {
        this._titleColors = colors;
    }

    public void setShadow(boolean value) {
        this._hasShadow = value;
    }

    boolean hasShadow() {
        return this._hasShadow;
    }

    private CharColor getShadowColors() {
        return __shadowColors;
    }

    public void addListener(WindowListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(WindowListener listener) {
        this._listenerManager.removeListener(listener);
    }

    protected void activate() {
        this._listenerManager.handleEvent(new WindowEvent(this, 2));
    }

    protected void deactivate() {
        this._listenerManager.handleEvent(new WindowEvent(this, 3));
    }

    protected void closed() {
        this._closed = true;
        this._listenerManager.handleEvent(new WindowEvent(this, 0));
    }

    protected void resize(int width, int height) {
        this._rect.setWidth(width);
        this._rect.setHeight(height);
    }
}

